/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.electric;

import argent_matter.gcyr.api.space.satellite.capability.SatelliteWorldSavedData;
import argent_matter.gcyr.common.satellite.OreFinderSatellite;
import argent_matter.gcyr.util.Vec2i;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OreFinderScannerMachine
extends TieredEnergyMachine {
    public static final int MACHINE_RANGE_MULTIPLIER = 16;
    private final Map<BlockState, String> BLOCK_CACHE = new HashMap<BlockState, String>();
    private final int range = this.tier * 16;

    public OreFinderScannerMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
    }

    public void scanOres(BlockState[][][] storage) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos myPos = this.getPos();
            storage = new BlockState[32][32][0];
            List satellites = SatelliteWorldSavedData.getOrCreate(serverLevel).getSatellitesNearPos(new Vec2i(myPos.m_123341_(), myPos.m_123343_()), this.range).stream().filter(OreFinderSatellite.class::isInstance).map(OreFinderSatellite.class::cast).collect(Collectors.toList());
            for (OreFinderSatellite satellite : satellites) {
                satellite.scan(storage, (Level)serverLevel);
            }
        }
    }

    public int getItemColor(BlockState state) {
        Material mat;
        String itemName = this.BLOCK_CACHE.computeIfAbsent(state, blockState -> {
            Object name = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString();
            UnificationEntry entry = ChemicalHelper.getUnificationEntry((ItemLike)blockState.m_60734_());
            if (entry != null && entry.material != null) {
                name = "material_" + entry.material;
            }
            return name;
        });
        if (itemName.startsWith("material_") && (mat = GTMaterials.get((String)itemName.substring(9))) != null) {
            return mat.getMaterialRGB();
        }
        return ((Block)BuiltInRegistries.f_256975_.m_7745_((ResourceLocation)new ResourceLocation((String)itemName))).m_284356_().f_283871_;
    }
}

