/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.item;

import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.util.PosWithState;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StationContainerBehaviour
implements IAddInformation {
    private static final String SATELLITE_BLOCKS_KEY = "gcyr:satellite_blocks";

    @Nullable
    public static Set<PosWithState> getStationBlocks(ItemStack stack) {
        if (!GCYRItems.SPACE_STATION_PACKAGE.isIn(stack)) {
            return null;
        }
        if (!stack.m_41782_() || !stack.m_41783_().m_128425_(SATELLITE_BLOCKS_KEY, 9)) {
            return null;
        }
        HashSet<PosWithState> states = new HashSet<PosWithState>();
        ListTag blocks = stack.m_41784_().m_128437_(SATELLITE_BLOCKS_KEY, 10);
        for (int i = 0; i < blocks.size(); ++i) {
            states.add(PosWithState.readFromTag(blocks.m_128728_(i)));
        }
        return states;
    }

    public static void setStationBlocks(ItemStack stack, Set<PosWithState> blocks) {
        if (!GCYRItems.SPACE_STATION_PACKAGE.isIn(stack)) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128425_(SATELLITE_BLOCKS_KEY, 9)) {
            return;
        }
        ListTag blockTag = new ListTag();
        for (PosWithState state : blocks) {
            blockTag.add((Object)state.writeToTag());
        }
        stack.m_41784_().m_128365_(SATELLITE_BLOCKS_KEY, (Tag)blockTag);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (!(GCYRItems.SPACE_STATION_PACKAGE.isIn(stack) && stack.m_41782_() && stack.m_41783_().m_128425_(SATELLITE_BLOCKS_KEY, 9))) {
            return;
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.gcyr.satellite_package.has_satellite"));
    }
}

