/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.item;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.data.GCYRMenus;
import argent_matter.gcyr.data.loader.PlanetData;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlanetIdChipBehaviour
implements IInteractionItem,
IAddInformation {
    public static final String CURRENT_STATION_KEY = "gcyr:current_station";
    public static final String CURRENT_PLANET_KEY = "gcyr:current_planet";
    public static final String CURRENT_POS_KEY = "gcyr:current_position";

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GCYRMenus.PLANET_SELECTION.open(serverPlayer, (Component)Component.m_237115_((String)"gui.gcyr.planet_selector"), PlanetData::writePlanetData);
            return InteractionResultHolder.m_19096_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public static void setSpaceStation(ItemStack held, int stationId) {
        if (!GCYRItems.ID_CHIP.isIn(held) || stationId == Integer.MIN_VALUE) {
            return;
        }
        held.m_41784_().m_128405_(CURRENT_STATION_KEY, stationId);
    }

    @Nullable
    public static Integer getSpaceStationId(ItemStack held) {
        if (!GCYRItems.ID_CHIP.isIn(held) || !held.m_41784_().m_128425_(CURRENT_STATION_KEY, 3)) {
            return null;
        }
        return held.m_41784_().m_128451_(CURRENT_STATION_KEY);
    }

    @Nullable
    public static Planet getPlanetFromStack(ItemStack stack) {
        return PlanetData.getPlanetFromLevelOrOrbit((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41784_().m_128461_(CURRENT_PLANET_KEY)))).orElse(null);
    }

    public static void setSavedPosition(ItemStack stack, ResourceKey<Level> level, BlockPos pos) {
        if (!GCYRItems.ID_CHIP.isIn(stack)) {
            return;
        }
        stack.m_41784_().m_128359_(CURRENT_PLANET_KEY, level.m_135782_().toString());
        stack.m_41783_().m_128365_(CURRENT_POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    @Nullable
    public static GlobalPos getSavedPosition(ItemStack stack) {
        if (!GCYRItems.ID_CHIP.isIn(stack)) {
            return null;
        }
        if (!stack.m_41782_() || !stack.m_41784_().m_128441_(CURRENT_POS_KEY)) {
            return null;
        }
        ResourceLocation currentLevel = new ResourceLocation(stack.m_41783_().m_128461_(CURRENT_PLANET_KEY));
        return GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)currentLevel), (BlockPos)NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_(CURRENT_POS_KEY)));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        BlockPos currentTargetPos;
        Integer currentStationId;
        Planet currentTarget = PlanetIdChipBehaviour.getPlanetFromStack(stack);
        if (currentTarget != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.planet_id_circuit.id").m_7220_((Component)Component.m_237115_((String)currentTarget.translation())));
        }
        if ((currentStationId = PlanetIdChipBehaviour.getSpaceStationId(stack)) != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.planet_id_circuit.station", (Object[])new Object[]{currentStationId}));
        }
        BlockPos blockPos = currentTargetPos = !stack.m_41782_() || !stack.m_41783_().m_128441_(CURRENT_POS_KEY) ? null : NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_(CURRENT_POS_KEY));
        if (currentTargetPos != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.planet_id_circuit.pos", (Object[])new Object[]{currentTargetPos.m_123341_(), currentTargetPos.m_123342_(), currentTargetPos.m_123343_()}));
        }
    }
}

