/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.entity.data;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.common.item.armor.SpaceSuitArmorItem;
import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.data.recipe.GCYRTags;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EntityOxygenSystem {
    public static final Table<ResourceKey<Level>, BlockPos, Set<BlockPos>> OXYGEN_LOCATIONS = Tables.newCustomTable(new IdentityHashMap(), HashMap::new);

    public static boolean levelHasOxygen(Level level) {
        return PlanetData.isOxygenated(level);
    }

    public static void setEntry(Level level, BlockPos source, Set<BlockPos> entries) {
        HashSet<BlockPos> changedPositions;
        if (!level.f_46443_ && OXYGEN_LOCATIONS.contains((Object)level.m_46472_(), (Object)source) && (changedPositions = new HashSet<BlockPos>((Collection)OXYGEN_LOCATIONS.get((Object)level.m_46472_(), (Object)source))) != null && !changedPositions.isEmpty()) {
            changedPositions.removeAll(entries);
            EntityOxygenSystem.deoxygenizeBlocks((ServerLevel)level, changedPositions, source);
        }
        OXYGEN_LOCATIONS.put((Object)level.m_46472_(), (Object)source, entries);
    }

    public static void removeEntry(Level level, BlockPos source) {
        EntityOxygenSystem.setEntry(level, source, Set.of());
    }

    public static void oxygenTick(LivingEntity entity, ServerLevel level) {
        boolean hasOxygenatedSpaceSuit;
        if (!GCYRConfig.INSTANCE.server.enableOxygen) {
            return;
        }
        if (entity.m_21222_()) {
            return;
        }
        if (entity.m_6095_().m_204039_(GCYRTags.IGNORE_OXYGEN)) {
            return;
        }
        if (!PlanetData.isSpaceLevel((Level)level) && !entity.m_5842_()) {
            return;
        }
        boolean entityHasOxygen = EntityOxygenSystem.entityHasOxygen((Level)level, entity);
        boolean bl = hasOxygenatedSpaceSuit = SpaceSuitArmorItem.hasOxygenatedSpaceSuit(entity) && SpaceSuitArmorItem.hasFullSet(entity);
        if (entityHasOxygen && hasOxygenatedSpaceSuit && entity.m_5842_() && !entity.m_6040_() && !entity.m_21023_(MobEffects.f_19608_)) {
            EntityOxygenSystem.consumeOxygen(entity);
            return;
        }
        if (!entityHasOxygen) {
            if (hasOxygenatedSpaceSuit) {
                EntityOxygenSystem.consumeOxygen(entity);
            } else if (!StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(stack -> stack.m_204117_(GCYRTags.SPACESUIT_ARMOR))) {
                entity.m_6469_(level.m_269111_().m_269063_(), GCYRConfig.INSTANCE.server.oxygenDamage);
                entity.m_20301_(-40);
            }
        }
    }

    public static void deoxygenizeBlocks(ServerLevel level, Set<BlockPos> entries, BlockPos source) {
        try {
            if (entries == null) {
                return;
            }
            if (entries.isEmpty()) {
                return;
            }
            if (EntityOxygenSystem.levelHasOxygen((Level)level)) {
                OXYGEN_LOCATIONS.remove((Object)level.m_46472_(), (Object)source);
                return;
            }
            for (BlockPos pos : new HashSet<BlockPos>(entries)) {
                BlockState state = level.m_8055_(pos);
                ((Set)OXYGEN_LOCATIONS.get((Object)level.m_46472_(), (Object)source)).remove(pos);
                if (EntityOxygenSystem.posHasOxygen((Level)level, pos) || state.m_60795_()) continue;
                Block block = state.m_60734_();
                if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof FireBlock) {
                    level.m_7471_(pos, false);
                    continue;
                }
                if (block instanceof GrassBlock) {
                    level.m_46597_(pos, Blocks.f_50493_.m_49966_());
                    continue;
                }
                if (block instanceof BushBlock || block instanceof CactusBlock || block instanceof VineBlock) {
                    level.m_7471_(pos, true);
                    continue;
                }
                if (block instanceof FarmBlock) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(0)));
                    continue;
                }
                if (!state.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (PlanetData.getWorldTemperature((Level)level) < 273.0f) {
                    level.m_46597_(pos, Blocks.f_50126_.m_49966_());
                    continue;
                }
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
        catch (UnsupportedOperationException e) {
            GCYR.LOGGER.error("Error deoxygenizing blocks");
            e.printStackTrace();
        }
    }

    private static void consumeOxygen(LivingEntity entity) {
        if (entity.m_9236_().m_46467_() % 3L == 0L) {
            entity.m_20301_(Math.min(entity.m_6062_(), entity.m_20146_() + 40));
            SpaceSuitArmorItem.consumeSpaceSuitOxygen(entity, 1);
        }
    }

    public static boolean entityHasOxygen(Level level, LivingEntity entity) {
        return EntityOxygenSystem.posHasOxygen(level, BlockPos.m_274446_((Position)entity.m_146892_()));
    }

    public static boolean posHasOxygen(Level level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            return true;
        }
        if (EntityOxygenSystem.levelHasOxygen(level)) {
            return true;
        }
        return EntityOxygenSystem.inDistributorBubble(level, pos);
    }

    public static boolean inDistributorBubble(Level level, BlockPos pos) {
        for (Set entry : OXYGEN_LOCATIONS.row((Object)level.m_46472_()).values()) {
            if (!entry.contains(pos)) continue;
            return true;
        }
        return false;
    }
}

