/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.util.PosWithState;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GCYREntityDataSerializers {
    public static final EntityDataSerializer<Long> LONG = EntityDataSerializer.m_238095_(FriendlyByteBuf::m_130103_, FriendlyByteBuf::m_130258_);
    public static final EntityDataSerializer<List<BlockPos>> BLOCK_POS_LIST = new EntityDataSerializer<List<BlockPos>>(){

        public void write(FriendlyByteBuf buffer, List<BlockPos> value) {
            buffer.m_236828_(value, (arg_0, arg_1) -> ((EntityDataSerializer)EntityDataSerializers.f_135038_).m_6856_(arg_0, arg_1));
        }

        public List<BlockPos> read(FriendlyByteBuf buffer) {
            return buffer.m_236845_(arg_0 -> ((EntityDataSerializer)EntityDataSerializers.f_135038_).m_6709_(arg_0));
        }

        public List<BlockPos> copy(List<BlockPos> value) {
            return new ArrayList<BlockPos>(value);
        }
    };
    public static final EntityDataSerializer<PosWithState> POSITIONED_BLOCK_STATE = new EntityDataSerializer<PosWithState>(){

        public void write(FriendlyByteBuf friendlyByteBuf, PosWithState posState) {
            EntityDataSerializers.f_135038_.m_6856_(friendlyByteBuf, (Object)posState.pos());
            EntityDataSerializers.f_135034_.m_6856_(friendlyByteBuf, (Object)posState.state());
            if (posState.entityTag() != null) {
                friendlyByteBuf.writeBoolean(true);
                EntityDataSerializers.f_135042_.m_6856_(friendlyByteBuf, (Object)posState.entityTag());
            } else {
                friendlyByteBuf.writeBoolean(false);
            }
        }

        public PosWithState read(FriendlyByteBuf friendlyByteBuf) {
            BlockPos pos = (BlockPos)EntityDataSerializers.f_135038_.m_6709_(friendlyByteBuf);
            BlockState state = (BlockState)EntityDataSerializers.f_135034_.m_6709_(friendlyByteBuf);
            CompoundTag tag = null;
            if (friendlyByteBuf.readBoolean()) {
                tag = (CompoundTag)EntityDataSerializers.f_135042_.m_6709_(friendlyByteBuf);
            }
            return new PosWithState(pos, state, tag);
        }

        public PosWithState copy(PosWithState value) {
            return new PosWithState(value.pos(), value.state());
        }
    };
    public static final EntityDataSerializer<List<PosWithState>> POSITIONED_BLOCK_STATE_LIST = new EntityDataSerializer<List<PosWithState>>(){

        public void write(FriendlyByteBuf buffer, List<PosWithState> value) {
            buffer.m_236828_(value, (arg_0, arg_1) -> POSITIONED_BLOCK_STATE.m_6856_(arg_0, arg_1));
        }

        public List<PosWithState> read(FriendlyByteBuf buffer) {
            return buffer.m_236845_(arg_0 -> POSITIONED_BLOCK_STATE.m_6709_(arg_0));
        }

        public List<PosWithState> copy(List<PosWithState> value) {
            return new ArrayList<PosWithState>(value);
        }
    };
    public static final EntityDataSerializer<Optional<Planet>> PLANET = new EntityDataSerializer.ForValueType<Optional<Planet>>(){

        public void write(FriendlyByteBuf buffer, Optional<Planet> value) {
            if (value.isPresent()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(PlanetData.getPlanetId(value.get()));
            } else {
                buffer.writeBoolean(false);
            }
        }

        public Optional<Planet> read(FriendlyByteBuf buffer) {
            return buffer.readBoolean() ? Optional.of(PlanetData.getPlanet(buffer.m_130281_())) : Optional.empty();
        }
    };

    public static void init() {
        EntityDataSerializers.m_135050_(LONG);
        EntityDataSerializers.m_135050_(BLOCK_POS_LIST);
        EntityDataSerializers.m_135050_(POSITIONED_BLOCK_STATE);
        EntityDataSerializers.m_135050_(POSITIONED_BLOCK_STATE_LIST);
        EntityDataSerializers.m_135050_(PLANET);
    }
}

