/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.api.block.IFuelTankProperties;
import argent_matter.gcyr.api.block.IRocketMotorType;
import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.common.block.FuelTankBlock;
import argent_matter.gcyr.common.block.RocketMotorBlock;
import argent_matter.gcyr.common.data.GCYRCreativeModeTabs;
import argent_matter.gcyr.common.data.GCYRModels;
import argent_matter.gcyr.data.recipe.GCYRTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;

public class GCYRBlocks {
    public static final BlockEntry<Block> CASING_ALUMINIUM_AEROSPACE;
    public static final BlockEntry<Block> CASING_BEAM_RECEIVER;
    public static final BlockEntry<Block> CASING_SUPPORT;
    public static final BlockEntry<Block> CASING_DYSON_SPHERE;
    public static final BlockEntry<Block> CASING_DYSON_CELL;
    public static final BlockEntry<Block> CASING_DYSON_PORT;
    public static final BlockEntry<Block> CASING_STAINLESS_EVAPORATION;
    public static final BlockSetType MERCURY_SET;
    public static final BlockEntry<Block> MERCURY_COBBLESTONE;
    public static final BlockEntry<Block> MERCURY_ROCK;
    public static final BlockEntry<SlabBlock> MERCURY_COBBLESTONE_SLAB;
    public static final BlockEntry<SlabBlock> MERCURY_ROCK_SLAB;
    public static final BlockEntry<StairBlock> MERCURY_COBBLESTONE_STAIRS;
    public static final BlockEntry<StairBlock> MERCURY_ROCK_STAIRS;
    public static final BlockEntry<ButtonBlock> MERCURY_ROCK_BUTTON;
    public static final BlockSetType VENUS_SET;
    public static final BlockEntry<FallingBlock> VENUS_SAND;
    public static final BlockEntry<Block> VENUSIAN_REGOLITH;
    public static final BlockEntry<Block> VENUS_COBBLESTONE;
    public static final BlockEntry<Block> VENUS_ROCK;
    public static final BlockEntry<SlabBlock> VENUS_COBBLESTONE_SLAB;
    public static final BlockEntry<SlabBlock> VENUS_ROCK_SLAB;
    public static final BlockEntry<StairBlock> VENUS_COBBLESTONE_STAIRS;
    public static final BlockEntry<StairBlock> VENUS_ROCK_STAIRS;
    public static final BlockEntry<ButtonBlock> VENUS_ROCK_BUTTON;
    public static final BlockSetType MOON_SET;
    public static final BlockEntry<Block> MOON_COBBLESTONE;
    public static final BlockEntry<Block> MOON_STONE;
    public static final BlockEntry<FallingBlock> MOON_SAND;
    public static final BlockEntry<SlabBlock> MOON_COBBLESTONE_SLAB;
    public static final BlockEntry<SlabBlock> MOON_STONE_SLAB;
    public static final BlockEntry<StairBlock> MOON_COBBLESTONE_STAIRS;
    public static final BlockEntry<StairBlock> MOON_STONE_STAIRS;
    public static final BlockEntry<ButtonBlock> MOON_STONE_BUTTON;
    public static final BlockSetType MARS_SET;
    public static final BlockEntry<FallingBlock> MARS_REGOLITH;
    public static final BlockEntry<Block> MARTIAN_COBBLESTONE;
    public static final BlockEntry<Block> MARTIAN_ROCK;
    public static final BlockEntry<SlabBlock> MARTIAN_COBBLESTONE_SLAB;
    public static final BlockEntry<SlabBlock> MARTIAN_ROCK_SLAB;
    public static final BlockEntry<StairBlock> MARTIAN_COBBLESTONE_STAIRS;
    public static final BlockEntry<StairBlock> MARTIAN_ROCK_STAIRS;
    public static final BlockEntry<ButtonBlock> MARTIAN_ROCK_BUTTON;
    public static final BlockEntry<MushroomBlock> PRB_SHROOM;
    public static final Map<IRocketMotorType, Supplier<RocketMotorBlock>> ALL_ROCKET_MOTORS;
    public static final BlockEntry<RocketMotorBlock> BASIC_ROCKET_MOTOR;
    public static final BlockEntry<RocketMotorBlock> ADVANCED_ROCKET_MOTOR;
    public static final BlockEntry<RocketMotorBlock> ELITE_ROCKET_MOTOR;
    public static final BlockEntry<DoorBlock> AIRLOCK_DOOR;
    public static final BlockEntry<Block> LAUNCH_PAD;
    public static final BlockEntry<CarpetBlock> SEAT;
    public static final Map<IFuelTankProperties, Supplier<FuelTankBlock>> ALL_FUEL_TANKS;
    public static final BlockEntry<FuelTankBlock> BASIC_FUEL_TANK;
    public static final BlockEntry<FuelTankBlock> ADVANCED_FUEL_TANK;
    public static final BlockEntry<FuelTankBlock> ELITE_FUEL_TANK;

    private static BlockEntry<Block> createCasingBlock(String name, ResourceLocation texture) {
        return GCYRBlocks.createCasingBlock(name, Block::new, texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50075_), () -> RenderType::m_110457_);
    }

    private static BlockEntry<Block> createGlassCasingBlock(String name, ResourceLocation texture, Supplier<Supplier<RenderType>> type) {
        return GCYRBlocks.createCasingBlock(name, GlassBlock::new, texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50058_), type);
    }

    private static BlockEntry<Block> createCasingBlock(String name, Function<BlockBehaviour.Properties, ? extends Block> blockSupplier, ResourceLocation texture, NonNullSupplier<? extends Block> properties, Supplier<Supplier<RenderType>> type) {
        return ((BlockBuilder)GCYRRegistries.REGISTRATE.block(name, p -> (Block)blockSupplier.apply((BlockBehaviour.Properties)p)).initialProperties(properties).addLayer(type).blockstate(GCYRModels.cubeAllModel(name, texture)).tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH, BlockTags.f_144282_}).item(BlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<FuelTankBlock> createFuelTank(IFuelTankProperties properties) {
        BlockEntry block = GCYRRegistries.REGISTRATE.block("%s_fuel_tank".formatted(properties.m_7912_()), p -> new FuelTankBlock((BlockBehaviour.Properties)p, properties)).initialProperties(() -> Blocks.f_50075_).lang("%s Fuel Tank".formatted(FormattingUtil.toEnglishName((Object)properties.m_7912_()))).blockstate(GCYRModels::fuelTankModel).tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH}).simpleItem().register();
        ALL_FUEL_TANKS.put(properties, (Supplier<FuelTankBlock>)block);
        return block;
    }

    private static BlockEntry<RocketMotorBlock> createRocketMotor(IRocketMotorType type) {
        BlockEntry block = GCYRRegistries.REGISTRATE.block("%s_rocket_motor".formatted(type.m_7912_()), p -> new RocketMotorBlock((BlockBehaviour.Properties)p, type)).initialProperties(() -> Blocks.f_50075_).lang("%s Rocket Motor".formatted(FormattingUtil.toEnglishName((Object)type.m_7912_()))).blockstate((ctx, prov) -> GCYRModels.rocketMotorModel((DataGenContext<Block, RocketMotorBlock>)ctx, prov, type)).tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH}).simpleItem().register();
        ALL_ROCKET_MOTORS.put(type, (Supplier<RocketMotorBlock>)block);
        return block;
    }

    public static void init() {
    }

    static {
        GCYRRegistries.REGISTRATE.creativeModeTab(() -> GCYRCreativeModeTabs.GCYR);
        CASING_ALUMINIUM_AEROSPACE = GCYRBlocks.createCasingBlock("aerospace_aluminium_casing", GCYR.id("block/casings/solid/machine_casing_aerospace"));
        CASING_BEAM_RECEIVER = GCYRBlocks.createCasingBlock("beam_receiver", GCYR.id("block/casings/solid/beam_receiver"));
        CASING_SUPPORT = GCYRBlocks.createCasingBlock("space_elevator_support", GCYR.id("block/casings/solid/space_elevator_support"));
        CASING_DYSON_SPHERE = GCYRBlocks.createCasingBlock("dyson_sphere_casing", GCYR.id("block/casings/solid/dyson_sphere"));
        CASING_DYSON_CELL = GCYRBlocks.createCasingBlock("dyson_solar_cell", GCYR.id("block/casings/solid/dyson_solar_cell"));
        CASING_DYSON_PORT = GCYRBlocks.createCasingBlock("dyson_sphere_maintenance_port", GCYR.id("block/casings/solid/dyson_sphere_maintenance_port"));
        CASING_STAINLESS_EVAPORATION = GCYRBlocks.createCasingBlock("stainless_evaporation_casing", GCYR.id("block/casings/solid/machine_casing_stainless_evaporation"));
        MERCURY_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GCYR.id("mercury").toString()));
        MERCURY_COBBLESTONE = GCYRRegistries.REGISTRATE.block("mercury_rock", Block::new).lang("Cobbled Mercury Rock").initialProperties(() -> Blocks.f_50652_).properties(properties -> properties.m_284180_(MapColor.f_283818_)).blockstate(GCYRModels::randomRotatedModel).tag(new TagKey[]{BlockTags.f_144282_}).simpleItem().register();
        MERCURY_ROCK = GCYRRegistries.REGISTRATE.block("mercury_rock", Block::new).lang("Mercury Rock").properties(properties -> properties.m_284180_(MapColor.f_283818_)).blockstate(GCYRModels::randomRotatedModel).loot((table, block) -> table.m_246125_(block, (ItemLike)MERCURY_COBBLESTONE.m_5456_())).tag(new TagKey[]{BlockTags.f_144282_}).simpleItem().register();
        MERCURY_COBBLESTONE_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("mercury_cobblestone_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50409_).lang("Cobbled Mercury Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MERCURY_COBBLESTONE.get()), prov.blockTexture((Block)MERCURY_COBBLESTONE.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MERCURY_ROCK_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("mercury_rock_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50404_).lang("Mercury Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MERCURY_ROCK.get()), prov.blockTexture((Block)MERCURY_ROCK.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MERCURY_COBBLESTONE_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("cobbled_mercury_rock_stairs", p -> new StairBlock(() -> MERCURY_COBBLESTONE.getDefaultState(), p)).initialProperties(() -> Blocks.f_50157_).lang("Cobbled Mercury Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MERCURY_COBBLESTONE.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MERCURY_ROCK_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("mercury_rock_stairs", p -> new StairBlock(() -> MERCURY_ROCK.getDefaultState(), p)).initialProperties(() -> Blocks.f_50635_).lang("Mercury Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MERCURY_ROCK.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MERCURY_ROCK_BUTTON = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("mercury_rock_button", p -> new ButtonBlock(p, MERCURY_SET, 30, false)).initialProperties(() -> Blocks.f_50124_).lang("Mercury Rock Button").tag(new TagKey[]{BlockTags.f_13093_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)MERCURY_ROCK.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), MERCURY_ROCK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13171_}).build()).register();
        VENUS_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GCYR.id("venus").toString()));
        VENUS_SAND = GCYRRegistries.REGISTRATE.block("venus_sand", FallingBlock::new).lang("Venus Sand").initialProperties(() -> Blocks.f_49992_).properties(properties -> properties.m_284180_(MapColor.f_283895_)).tag(new TagKey[]{BlockTags.f_144283_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        VENUSIAN_REGOLITH = GCYRRegistries.REGISTRATE.block("venusian_regolith", Block::new).lang("Venusian Regolith").initialProperties(() -> Blocks.f_50062_).properties(properties -> properties.m_284180_(MapColor.f_283861_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        VENUS_COBBLESTONE = GCYRRegistries.REGISTRATE.block("venus_cobblestone", Block::new).lang("Cobbled Venus Rock").initialProperties(() -> Blocks.f_50652_).properties(properties -> properties.m_284180_(MapColor.f_283818_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        VENUS_ROCK = GCYRRegistries.REGISTRATE.block("venus_rock", Block::new).lang("Venus Rock").initialProperties(() -> Blocks.f_50069_).properties(properties -> properties.m_284180_(MapColor.f_283907_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).loot((table, block) -> table.m_246125_(block, (ItemLike)VENUS_COBBLESTONE.m_5456_())).simpleItem().register();
        VENUS_COBBLESTONE_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("venus_cobblestone_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50409_).lang("Cobbled Venus Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)VENUS_COBBLESTONE.get()), prov.blockTexture((Block)VENUS_COBBLESTONE.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        VENUS_ROCK_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("venus_rock_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50404_).lang("Venus Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)VENUS_ROCK.get()), prov.blockTexture((Block)VENUS_ROCK.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        VENUS_COBBLESTONE_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("venus_cobblestone_stairs", p -> new StairBlock(() -> VENUS_COBBLESTONE.getDefaultState(), p)).initialProperties(() -> Blocks.f_50157_).lang("Cobbled Venus Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)VENUS_COBBLESTONE.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        VENUS_ROCK_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("venus_rock_stairs", p -> new StairBlock(() -> VENUS_ROCK.getDefaultState(), p)).initialProperties(() -> Blocks.f_50635_).lang("Venus Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)VENUS_ROCK.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        VENUS_ROCK_BUTTON = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("venus_rock_button", p -> new ButtonBlock(p, VENUS_SET, 30, false)).initialProperties(() -> Blocks.f_50124_).lang("Venus Rock Button").tag(new TagKey[]{BlockTags.f_13093_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)VENUS_ROCK.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), VENUS_ROCK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13171_}).build()).register();
        MOON_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GCYR.id("moon").toString()));
        MOON_COBBLESTONE = GCYRRegistries.REGISTRATE.block("moon_cobblestone", Block::new).lang("Cobbled Lunar Stone").initialProperties(() -> Blocks.f_50652_).properties(properties -> properties.m_284180_(MapColor.f_283818_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        MOON_STONE = GCYRRegistries.REGISTRATE.block("moon_stone", Block::new).lang("Lunar Stone").initialProperties(() -> Blocks.f_50069_).properties(properties -> properties.m_284180_(MapColor.f_283779_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).loot((table, block) -> table.m_246125_(block, (ItemLike)MOON_COBBLESTONE.m_5456_())).simpleItem().register();
        MOON_SAND = GCYRRegistries.REGISTRATE.block("moon_sand", FallingBlock::new).lang("Lunar Sand").initialProperties(() -> Blocks.f_49994_).tag(new TagKey[]{BlockTags.f_144283_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        MOON_COBBLESTONE_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("moon_cobblestone_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50409_).lang("Cobbled Lunar Stone Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MOON_COBBLESTONE.get()), prov.blockTexture((Block)MOON_COBBLESTONE.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MOON_STONE_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("moon_stone_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50404_).lang("Lunar Stone Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MOON_STONE.get()), prov.blockTexture((Block)MOON_STONE.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MOON_COBBLESTONE_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("moon_cobblestone_stairs", p -> new StairBlock(() -> MOON_COBBLESTONE.getDefaultState(), p)).initialProperties(() -> Blocks.f_50157_).lang("Cobbled Lunar Stone Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MOON_COBBLESTONE.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MOON_STONE_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("moon_stone_stairs", p -> new StairBlock(() -> MOON_STONE.getDefaultState(), p)).initialProperties(() -> Blocks.f_50635_).lang("Lunar Stone Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MOON_STONE.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MOON_STONE_BUTTON = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("moon_stone_button", p -> new ButtonBlock(p, MOON_SET, 30, false)).initialProperties(() -> Blocks.f_50124_).lang("Lunar Stone Button").tag(new TagKey[]{BlockTags.f_13093_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)MOON_STONE.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), MOON_STONE.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13171_}).build()).register();
        MARS_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GCYR.id("martian").toString()));
        MARS_REGOLITH = GCYRRegistries.REGISTRATE.block("mars_regolith", FallingBlock::new).lang("Martian Regolith").initialProperties(() -> Blocks.f_49993_).tag(new TagKey[]{BlockTags.f_144282_}).simpleItem().register();
        MARTIAN_COBBLESTONE = GCYRRegistries.REGISTRATE.block("martian_cobblestone", Block::new).lang("Cobbled Martian Rock").initialProperties(() -> Blocks.f_50652_).properties(properties -> properties.m_284180_(MapColor.f_283818_)).tag(new TagKey[]{BlockTags.f_144282_}).blockstate(GCYRModels::randomRotatedModel).simpleItem().register();
        MARTIAN_ROCK = GCYRRegistries.REGISTRATE.block("martian_rock", Block::new).lang("Martian Rock").initialProperties(() -> Blocks.f_50069_).properties(properties -> properties.m_284180_(MapColor.f_283913_)).tag(new TagKey[]{BlockTags.f_144282_}).loot((table, block) -> table.m_246125_(block, (ItemLike)MARTIAN_COBBLESTONE.m_5456_())).simpleItem().register();
        MARTIAN_COBBLESTONE_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("martian_cobblestone_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50409_).lang("Cobbled Martian Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MARTIAN_COBBLESTONE.get()), prov.blockTexture((Block)MARTIAN_COBBLESTONE.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MARTIAN_ROCK_SLAB = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("martian_rock_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50404_).lang("Martian Rock Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)MARTIAN_ROCK.get()), prov.blockTexture((Block)MARTIAN_ROCK.get()))).tag(new TagKey[]{BlockTags.f_13031_, BlockTags.f_144282_}).item().tag(new TagKey[]{ItemTags.f_13139_}).build()).register();
        MARTIAN_COBBLESTONE_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("martian_cobblestone_stairs", p -> new StairBlock(() -> MARTIAN_COBBLESTONE.getDefaultState(), p)).initialProperties(() -> Blocks.f_50157_).lang("Cobbled Martian Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MARTIAN_COBBLESTONE.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MARTIAN_ROCK_STAIRS = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("martian_rock_stairs", p -> new StairBlock(() -> MARTIAN_ROCK.getDefaultState(), p)).initialProperties(() -> Blocks.f_50635_).lang("Martian Rock Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)MARTIAN_ROCK.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        MARTIAN_ROCK_BUTTON = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("martian_rock_button", p -> new ButtonBlock(p, MARS_SET, 30, false)).initialProperties(() -> Blocks.f_50124_).lang("Martian Rock Button").tag(new TagKey[]{BlockTags.f_13093_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)MARTIAN_ROCK.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), MARTIAN_ROCK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13171_}).build()).register();
        PRB_SHROOM = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("prb_underground_mushroom", p -> new MushroomBlock(p, null)).initialProperties(() -> Blocks.f_50072_).properties(p -> p.m_284180_(MapColor.f_283772_)).addLayer(() -> RenderType::m_110463_).blockstate(GCYRModels::crossModel).item().model(GCYRModels::blockTextureGeneratedModel).build()).register();
        ALL_ROCKET_MOTORS = new HashMap<IRocketMotorType, Supplier<RocketMotorBlock>>();
        BASIC_ROCKET_MOTOR = GCYRBlocks.createRocketMotor(RocketMotorBlock.RocketMotorType.BASIC);
        ADVANCED_ROCKET_MOTOR = GCYRBlocks.createRocketMotor(RocketMotorBlock.RocketMotorType.ADVANCED);
        ELITE_ROCKET_MOTOR = GCYRBlocks.createRocketMotor(RocketMotorBlock.RocketMotorType.ELITE);
        AIRLOCK_DOOR = ((BlockBuilder)GCYRRegistries.REGISTRATE.block("airlock_door", properties -> new DoorBlock(properties, BlockSetType.f_271132_)).initialProperties(() -> Blocks.f_50075_).lang("Airlock Door").properties(p -> p.m_60913_(4.0f, 6.0f)).tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH, BlockTags.f_144282_, GCYRTags.BLOCKS_FLOOD_FILL}).blockstate(GCYRModels::airlockDoorModel).item().tag(new TagKey[]{ItemTags.f_13179_}).defaultModel().build()).register();
        LAUNCH_PAD = GCYRRegistries.REGISTRATE.block("launch_pad", Block::new).initialProperties(() -> Blocks.f_50075_).lang("Launch Pad").defaultBlockstate().tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH, BlockTags.f_144282_}).simpleItem().register();
        SEAT = GCYRRegistries.REGISTRATE.block("seat", CarpetBlock::new).initialProperties(() -> Blocks.f_50075_).lang("Seat").blockstate(GCYRModels::seatModel).tag(new TagKey[]{GCYRTags.MINEABLE_WITH_WRENCH, BlockTags.f_144282_}).simpleItem().register();
        ALL_FUEL_TANKS = new HashMap<IFuelTankProperties, Supplier<FuelTankBlock>>();
        BASIC_FUEL_TANK = GCYRBlocks.createFuelTank(FuelTankBlock.FuelTankProperties.BASIC);
        ADVANCED_FUEL_TANK = GCYRBlocks.createFuelTank(FuelTankBlock.FuelTankProperties.ADVANCED);
        ELITE_FUEL_TANK = GCYRBlocks.createFuelTank(FuelTankBlock.FuelTankProperties.ELITE);
    }
}

