/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.client.gui.screen;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.api.space.planet.Galaxy;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.api.space.planet.PlanetRing;
import argent_matter.gcyr.api.space.planet.SolarSystem;
import argent_matter.gcyr.client.gui.Category;
import argent_matter.gcyr.client.gui.screen.ExtendedButton;
import argent_matter.gcyr.common.data.GCYRNetworking;
import argent_matter.gcyr.common.gui.PlanetSelectionMenu;
import argent_matter.gcyr.common.networking.c2s.PacketCreateSpaceStation;
import argent_matter.gcyr.common.networking.c2s.PacketSendSelectedDimension;
import argent_matter.gcyr.data.loader.PlanetData;
import com.gregtechceu.gtceu.GTCEu;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlanetSelectionScreen
extends Screen
implements MenuAccess<PlanetSelectionMenu> {
    public static final ResourceLocation SMALL_MENU_LIST = GCYR.id("textures/gui/selection_menu.png");
    public static final ResourceLocation LARGE_MENU_TEXTURE = GCYR.id("textures/gui/selection_menu_large.png");
    public static final ResourceLocation SCROLL_BAR = GTCEu.id((String)"textures/gui/widget/slider.png");
    private static final Component CATALOG_TEXT = Component.m_237115_((String)"menu.gcyr.catalog");
    private static final Component BACK_TEXT = Component.m_237115_((String)"menu.gcyr.back");
    public static final Component PLANET_TEXT = Component.m_237115_((String)"menu.gcyr.planet");
    public static final Component MOON_TEXT = Component.m_237115_((String)"menu.gcyr.moon");
    public static final Component ORBIT_TEXT = Component.m_237115_((String)"menu.gcyr.orbit");
    public static final Component NO_GRAVITY_TEXT = Component.m_237115_((String)"menu.gcyr.no_gravity");
    public static final Component SPACE_STATION_TEXT = Component.m_237115_((String)"menu.gcyr.space_station");
    public static final Component SOLAR_SYSTEM_TEXT = Component.m_237115_((String)"menu.gcyr.solar_system");
    public static final Component GALAXY_TEXT = Component.m_237115_((String)"menu.gcyr.galaxy");
    public static final Component CATEGORY_TEXT = Component.m_237115_((String)"menu.gcyr.category");
    public static final Component PROVIDED_TEXT = Component.m_237115_((String)"menu.gcyr.provided");
    public static final Component TYPE_TEXT = Component.m_237115_((String)"menu.gcyr.type");
    public static final Component GRAVITY_TEXT = Component.m_237115_((String)"menu.gcyr.gravity");
    public static final Component OXYGEN_TEXT = Component.m_237115_((String)"menu.gcyr.oxygen");
    public static final Component TEMPERATURE_TEXT = Component.m_237115_((String)"menu.gcyr.temperature");
    public static final Component OXYGEN_TRUE_TEXT = Component.m_237115_((String)"menu.gcyr.oxygen.true");
    public static final Component OXYGEN_FALSE_TEXT = Component.m_237115_((String)"menu.gcyr.oxygen.false");
    public static final int SCROLL_BAR_X = 92;
    public static final int SCROLL_SENSITIVITY = 5;
    final Set<Category> solarSystemsCategories = new HashSet<Category>();
    final Set<Category> galaxyCategories = new HashSet<Category>();
    private final PlanetSelectionMenu menu;
    private final Map<Category, LinkedList<ExtendedButton>> categoryButtons = new HashMap<Category, LinkedList<ExtendedButton>>();
    public int minScrollY = 177;
    public int maxScrollY = 274;
    private Category currentCategory = Category.GALAXY_CATEGORY;
    private float guiTime;
    private Button scrollBar;

    public PlanetSelectionScreen(PlanetSelectionMenu handler, Inventory inventory, Component title) {
        super(title);
        this.menu = handler;
        if (GCYRClient.galaxies.size() <= 1) {
            this.currentCategory = Category.MILKY_WAY_CATEGORY;
        }
        this.guiTime = handler.getPlayer().m_9236_().m_213780_().m_188501_() * 100000.0f;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.guiTime += delta;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280430_(this.f_96547_, CATALOG_TEXT, 29, (int)((float)this.f_96544_ / 2.0f - 71.5f), -1);
    }

    private void drawBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16776167);
        RenderSystem.enableBlend();
    }

    private void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawBackground(guiGraphics);
        int currentPage = this.getPage();
        SolarSystem solarSystem = null;
        HashSet<PlanetRing> planetRings = new HashSet<PlanetRing>();
        for (SolarSystem system : GCYRClient.solarSystems) {
            if (!this.currentCategory.id().equals((Object)system.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)system.solarSystem()))) continue;
            solarSystem = system;
            break;
        }
        for (PlanetRing ring : GCYRClient.planetRings) {
            if (!this.currentCategory.id().equals((Object)ring.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)ring.solarSystem()))) continue;
            planetRings.add(ring);
        }
        if (currentPage == 1) {
            GCYRClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)this.currentCategory.id())).findFirst().ifPresent(galaxy -> PlanetSelectionScreen.addRotatingTexture(this, guiGraphics, -125, -125, galaxy.scale(), galaxy.scale(), galaxy.texture(), 0.6f));
        } else if (solarSystem != null) {
            PlanetSelectionScreen.addTexture(guiGraphics, (this.f_96543_ - solarSystem.sunScale()) / 2, (this.f_96544_ - solarSystem.sunScale()) / 2, solarSystem.sunScale(), solarSystem.sunScale(), solarSystem.sun());
            for (PlanetRing ring : planetRings) {
                PlanetSelectionScreen.drawCircle((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, ring.radius() * 24.0, 75, solarSystem.ringColour());
            }
            for (PlanetRing ring : planetRings) {
                int coordinates = (int)(ring.radius() * 17.0 - (double)ring.scale() / 1.9);
                PlanetSelectionScreen.addRotatingTexture(this, guiGraphics, coordinates, coordinates, ring.scale(), ring.scale(), ring.texture(), 365.0f / (float)ring.speed());
            }
        }
        if (currentPage == 3) {
            PlanetSelectionScreen.addTexture(guiGraphics, 0, this.f_96544_ / 2 - 88, 215, 177, LARGE_MENU_TEXTURE);
            this.scrollBar.m_252865_(210);
        } else {
            PlanetSelectionScreen.addTexture(guiGraphics, 0, this.f_96544_ / 2 - 88, 105, 177, SMALL_MENU_LIST);
            this.scrollBar.m_252865_(92);
        }
        this.categoryButtons.forEach((category, buttons) -> buttons.forEach(button -> {
            button.f_93624_ = this.currentCategory.equals(category);
        }));
        Button backButton = this.categoryButtons.get(Category.BACK).get(0);
        boolean bl = backButton.f_93624_ = this.currentCategory.parent() != null;
        if (currentPage == 1 && GCYRClient.galaxies.size() <= 1) {
            backButton.f_93624_ = false;
        }
        if (this.categoryButtons.containsKey(this.currentCategory)) {
            this.scrollBar.f_93624_ = this.categoryButtons.get(this.currentCategory).size() > (currentPage == 3 ? 13 : 5);
        }
        this.minScrollY = this.f_96544_ / 2 - 33;
        this.maxScrollY = this.f_96544_ / 2 + 64;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableScissor();
    }

    protected void m_7856_() {
        super.m_7856_();
        LinkedList<ExtendedButton> backButtonList = new LinkedList<ExtendedButton>();
        ExtendedButton backButton = new ExtendedButton(10, this.f_96544_ / 2 - 36, 71, 20, 1.0f, 1.0f, 1.0f, BACK_TEXT, pressed -> this.onNavigationButtonClick(this.currentCategory.parent()));
        this.m_142416_((GuiEventListener)backButton);
        backButtonList.add(backButton);
        this.categoryButtons.put(Category.BACK, backButtonList);
        ArrayList<Planet> planets = new ArrayList<Planet>(PlanetData.planets().values());
        planets.sort(Comparator.comparing(p -> p.daysInYear()));
        planets.forEach(planet -> {
            Category galaxyCategory = new Category(planet.galaxy(), Category.GALAXY_CATEGORY);
            Category solarSystemCategory = new Category(planet.solarSystem(), galaxyCategory);
            Category planetCategory = new Category(planet.parentWorld() == null ? planet.level().m_135782_() : planet.parentWorld().m_135782_(), solarSystemCategory);
            MutableComponent label = Component.m_237115_((String)planet.translation());
            this.galaxyCategories.add(galaxyCategory);
            this.solarSystemsCategories.add(solarSystemCategory);
            if (planet.parentWorld() == null) {
                this.createNavigationButton((Component)label, solarSystemCategory, planet.buttonColor(), 71, 20, TooltipType.CATEGORY, (Planet)planet, planetCategory);
            }
            this.createTeleportButton(1, (Component)label, planetCategory, planet.buttonColor(), 71, 20, TooltipType.PLANET, (Planet)planet);
            this.createSpaceStationTeleportButton(2, SPACE_STATION_TEXT, planetCategory, planet.buttonColor(), 71, 20, (Planet)planet);
        });
        this.galaxyCategories.forEach(this::createGalaxyButton);
        this.solarSystemsCategories.forEach(this::createSolarSystemButton);
        this.scrollBar = new Button(92, this.minScrollY, 4, 8, Component.m_130674_((String)""), pressed -> {}, Button.f_252438_){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                if (this.f_93624_) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableDepthTest();
                    guiGraphics.m_280163_(SCROLL_BAR, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                }
            }
        };
        this.m_142416_((GuiEventListener)this.scrollBar);
    }

    public boolean m_7043_() {
        return true;
    }

    public void onNavigationButtonClick(Category target) {
        this.resetButtonScroll();
        this.scrollBar.m_253211_(this.minScrollY);
        this.currentCategory = target;
    }

    public void createGalaxyButton(Category galaxyCategory) {
        MutableComponent label = Component.m_237115_((String)galaxyCategory.id().m_214298_());
        Galaxy galaxy = GCYRClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)galaxyCategory.id())).findFirst().orElse(null);
        this.createNavigationButton((Component)label, Category.GALAXY_CATEGORY, galaxy != null ? galaxy.buttonColor() : -5635926, 75, 20, TooltipType.GALAXY, null, galaxyCategory);
    }

    public void createSolarSystemButton(Category solarSystemCategory) {
        MutableComponent label = Component.m_237115_((String)solarSystemCategory.id().m_214298_());
        SolarSystem solarSystem = GCYRClient.solarSystems.stream().filter(g -> g.solarSystem().equals((Object)solarSystemCategory.id())).findFirst().orElse(null);
        this.createNavigationButton((Component)label, solarSystemCategory.parent(), solarSystem != null ? solarSystem.buttonColor() : -16777046, 71, 20, TooltipType.SOLAR_SYSTEM, null, solarSystemCategory);
    }

    public void createNavigationButton(Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo, Category target) {
        this.createButton(label, category, colour, sizeX, sizeY, tooltip, planetInfo, press -> this.onNavigationButtonClick(target));
    }

    public void createTeleportButton(int row, Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo) {
        this.createTeleportButton(row, label, category, colour, sizeX, sizeY, tooltip, planetInfo, press -> this.selectPlanet(planetInfo));
    }

    public void createTeleportButton(int row, Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        int newRow = 0;
        if (row == 2) {
            newRow = 76;
        } else if (row == 3) {
            newRow = 118;
        }
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int column = this.getColumn(category) - (row - 1) * 22;
        this.createButton(newRow + 10, column -= 22 * (buttons.size() / 2), label, category, colour, sizeX, sizeY, tooltip, planetInfo, onClick);
    }

    public void createSpaceStationTeleportButton(int row, Component label, Category category, int colour, int sizeX, int sizeY, Planet planet) {
        this.createTeleportButton(row, label, category, colour, sizeX, sizeY, TooltipType.SPACE_STATION, planet, press -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.selectPlanet(planet);
                GCYRNetworking.NETWORK.sendToServer((IPacket)new PacketCreateSpaceStation());
            }
        });
    }

    public void selectPlanet(Planet planet) {
        this.f_96541_.f_91074_.m_6915_();
        GCYRNetworking.NETWORK.sendToServer((IPacket)new PacketSendSelectedDimension(planet.level().m_135782_()));
    }

    public Button createButton(Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        return this.createButton(10, label, category, colour, sizeX, sizeY, tooltip, planetInfo, onClick);
    }

    public Button createButton(int row, Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        int column = this.getColumn(category);
        return this.createButton(row, column, label, category, colour, sizeX, sizeY, tooltip, planetInfo, onClick);
    }

    public Button createButton(int row, int column, Component label, Category category, int colour, int sizeX, int sizeY, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        LinkedList<ExtendedButton> buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        float colourR = (float)((colour & 0xFF0000) >> 16) / 255.0f;
        float colourG = (float)((colour & 0xFF00) >> 8) / 255.0f;
        float colourB = (float)(colour & 0xFF) / 255.0f;
        ExtendedButton button = new ExtendedButton(row, column, sizeX, sizeY, colourR, colourG, colourB, label, onClick::accept, button1 -> this.renderButtonTooltip(planetInfo, tooltip, button1));
        this.m_142416_((GuiEventListener)button);
        buttons.add(button);
        this.categoryButtons.put(category, buttons);
        return button;
    }

    public List<FormattedCharSequence> renderButtonTooltip(Planet planetInfo, TooltipType tooltip, Button button) {
        LinkedList<MutableComponent> textEntries = new LinkedList<MutableComponent>();
        switch (tooltip) {
            case GALAXY: {
                textEntries.add(CATEGORY_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)button.m_6035_().m_6881_().m_130940_(ChatFormatting.AQUA)));
                textEntries.add(TYPE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)GALAXY_TEXT.m_6881_().m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case SOLAR_SYSTEM: {
                textEntries.add(CATEGORY_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)button.m_6035_().m_6881_().m_130940_(ChatFormatting.AQUA)));
                textEntries.add(TYPE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)SOLAR_SYSTEM_TEXT.m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
                break;
            }
            case CATEGORY: {
                textEntries.add(CATEGORY_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)button.m_6035_().m_6881_().m_130940_(ChatFormatting.GREEN)));
                textEntries.add(PROVIDED_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)Component.m_237110_((String)"menu.gcyr.rocket_tier", (Object[])new Object[]{planetInfo.rocketTier()}).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case PLANET: {
                textEntries.add(TYPE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)(planetInfo.parentWorld() == null ? PLANET_TEXT : MOON_TEXT).m_6881_().m_130940_(ChatFormatting.AQUA)));
                textEntries.add(GRAVITY_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(planetInfo.gravity() + " m/s")).m_130940_(ChatFormatting.AQUA)));
                textEntries.add(OXYGEN_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)(planetInfo.hasOxygen() ? OXYGEN_TRUE_TEXT : OXYGEN_FALSE_TEXT).m_6881_().m_130940_(planetInfo.hasOxygen() ? ChatFormatting.GREEN : ChatFormatting.RED)));
                ChatFormatting temperatureColour = ChatFormatting.GREEN;
                if (planetInfo.temperature() > 50.0f) {
                    temperatureColour = ChatFormatting.GOLD;
                } else if (planetInfo.temperature() < -20.0f) {
                    temperatureColour = ChatFormatting.DARK_BLUE;
                }
                textEntries.add(TEMPERATURE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(planetInfo.temperature() + " K")).m_130940_(temperatureColour)));
                break;
            }
        }
        if (tooltip.equals((Object)TooltipType.ORBIT) || tooltip.equals((Object)TooltipType.SPACE_STATION)) {
            textEntries.add(TYPE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)ORBIT_TEXT.m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
            textEntries.add(GRAVITY_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)NO_GRAVITY_TEXT.m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
            textEntries.add(OXYGEN_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)OXYGEN_FALSE_TEXT.m_6881_().m_130940_(ChatFormatting.RED)));
            textEntries.add(TEMPERATURE_TEXT.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)"3.0 K").m_130940_(ChatFormatting.DARK_BLUE)));
        }
        return textEntries.stream().map(Component::m_7532_).toList();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        for (Map.Entry<Category, LinkedList<ExtendedButton>> entry : this.categoryButtons.entrySet()) {
            if (!this.currentCategory.equals(entry.getKey())) continue;
            LinkedList<Button> buttons = new LinkedList<Button>();
            Button backButton = this.categoryButtons.get(Category.BACK).get(0);
            buttons.add(backButton);
            buttons.addAll((Collection)entry.getValue());
            boolean isLargePage = this.getPage() == 3;
            int overflowButtons = buttons.size() - (isLargePage ? 13 : 5);
            if (overflowButtons <= 0) break;
            int referencePoint = backButton.m_252907_();
            int minThreshold = this.f_96544_ / 2 - 35;
            int maxThreshold = this.f_96544_ / 2 - 38 - overflowButtons * (isLargePage ? 7 : 21);
            int sensitivity = (int)(5.0 * amount);
            if (amount > 0.0) {
                if (referencePoint >= minThreshold) {
                    sensitivity = 0;
                }
            } else if (amount < 0.0 && referencePoint <= maxThreshold) {
                sensitivity = 0;
            }
            for (Button button2 : buttons) {
                button2.m_253211_(button2.m_252907_() + sensitivity);
                if (referencePoint >= minThreshold) {
                    button2.m_253211_(button2.m_252907_() - referencePoint - minThreshold);
                    continue;
                }
                if (referencePoint > maxThreshold) continue;
                button2.m_253211_(button2.m_252907_() - referencePoint - maxThreshold);
            }
            float min = (float)maxThreshold / (float)minThreshold;
            float ratio = (float)backButton.m_252907_() / (float)minThreshold;
            ratio = Mth.m_184655_((float)ratio, (float)1.0f, (float)min);
            this.scrollBar.m_253211_((int)Mth.m_14179_((float)ratio, (float)this.maxScrollY, (float)this.minScrollY));
            this.scrollBar.m_253211_(Mth.m_14045_((int)this.scrollBar.m_252907_(), (int)this.minScrollY, (int)this.maxScrollY));
            break;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void resetButtonScroll() {
        this.categoryButtons.values().forEach(list -> list.forEach(button -> button.m_253211_(button.getStartY())));
    }

    private int getPage() {
        Category category = this.currentCategory;
        if (category.parent() == null) {
            return 0;
        }
        if (category.parent().parent() == null) {
            return 1;
        }
        if (category.parent().parent().parent() == null) {
            return 2;
        }
        if (category.parent().parent().parent().parent() == null) {
            return 3;
        }
        GCYR.LOGGER.warn("Invalid page!");
        return 0;
    }

    public int getColumn(Category category) {
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int index = buttons.size() + 1;
        int startY = this.f_96544_ / 2 - 58;
        if (Category.GALAXY_CATEGORY.equals(category.parent()) && GCYRClient.galaxies.size() <= 1) {
            return startY + 22 * index;
        }
        return startY + 22 * index + (category.parent() != null ? 22 : 0);
    }

    public void m_7379_() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && (minecraft.f_91074_.m_7500_() || minecraft.f_91074_.m_5833_())) {
            super.m_7379_();
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.categoryButtons.clear();
        this.resetButtonScroll();
        super.m_6574_(minecraft, width, height);
    }

    public static void addTexture(GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture) {
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void addRotatingTexture(PlanetSelectionScreen screen, GuiGraphics guiGraphics, int x, int y, int width, int height, ResourceLocation texture, float speed) {
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        ++x;
        ++y;
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)screen.f_96543_ / 2.0f, (float)screen.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(screen.getGuiTime() * (speed / 3.0f)));
        PlanetSelectionScreen.addTexture(guiGraphics, x, y, width, height, texture);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void drawCircle(double x, double y, double radius, int sides, int ringColour) {
        double width;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        for (double i = width = (radius *= scale) - 0.6; i < radius - 0.5 + 1.0; i += 0.1) {
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            for (int j = 0; j <= sides; ++j) {
                double angle = Math.PI * 2 * (double)j / (double)sides + Math.toRadians(180.0);
                bufferBuilder.m_5483_(x + Math.sin(angle) * i, y + Math.cos(angle) * i, 0.0).m_6122_(ringColour >> 16 & 0xFF, ringColour >> 8 & 0xFF, ringColour >> 0 & 0xFF, ringColour >> 24 & 0xFF).m_5752_();
            }
            tessellator.m_85914_();
        }
    }

    public PlanetSelectionMenu getMenu() {
        return this.menu;
    }

    public float getGuiTime() {
        return this.guiTime;
    }

    public static enum TooltipType {
        NONE,
        GALAXY,
        SOLAR_SYSTEM,
        CATEGORY,
        PLANET,
        ORBIT,
        SPACE_STATION;

    }
}

