/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.station;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.util.Vec2i;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.border.WorldBorder;

public class SpaceStation {
    public static final int ID_MAX = 31;
    public static final int ID_EMPTY = Integer.MIN_VALUE;
    public static final int BLOCK_MULTIPLIER = GCYRConfig.INSTANCE.server.spaceStationMaxSize;
    public static final int SIZE_BLOCKS = BLOCK_MULTIPLIER * BLOCK_MULTIPLIER;
    public static final Codec<SpaceStation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Planet.ID_CODEC.fieldOf("planet").forGetter(SpaceStation::orbitPlanet), (App)Vec2i.CODEC.fieldOf("pos").forGetter(SpaceStation::position)).apply((Applicative)instance, SpaceStation::new));
    private final Planet orbitPlanet;
    private final Vec2i position;
    private final WorldBorder border;

    public SpaceStation(Planet orbitPlanet, Vec2i position) {
        this.orbitPlanet = orbitPlanet;
        this.position = position;
        this.border = new WorldBorder();
        this.border.m_61949_((double)(position.x() * BLOCK_MULTIPLIER), (double)(position.y() * BLOCK_MULTIPLIER));
        this.border.m_61917_((double)BLOCK_MULTIPLIER);
    }

    public Planet orbitPlanet() {
        return this.orbitPlanet;
    }

    public Vec2i position() {
        return this.position;
    }

    public WorldBorder border() {
        return this.border;
    }
}

