/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.satellite.data;

import argent_matter.gcyr.util.Vec2i;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;

public record SatelliteData(Vec2i locationInWorld, int range, UUID owner) {
    public static Codec<SatelliteData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec2i.CODEC.fieldOf("pos").forGetter(SatelliteData::locationInWorld), (App)ExtraCodecs.f_144629_.fieldOf("range").forGetter(SatelliteData::range), (App)UUIDUtil.f_235867_.fieldOf("owner").forGetter(SatelliteData::owner)).apply((Applicative)instance, SatelliteData::new));
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    public static SatelliteData DEFAULT = new SatelliteData(Vec2i.ZERO, 0, EMPTY_UUID);

    public SatelliteData copy() {
        return new SatelliteData(new Vec2i(this.locationInWorld.x(), this.locationInWorld.y()), this.range, this.owner);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag pos = new CompoundTag();
        pos.m_128350_("x", (float)this.locationInWorld.x());
        pos.m_128350_("y", (float)this.locationInWorld.y());
        tag.m_128365_("pos", (Tag)pos);
        tag.m_128405_("range", this.range);
        tag.m_128362_("owner", this.owner);
        return tag;
    }

    public static SatelliteData deserializeNBT(CompoundTag nbt) {
        CompoundTag pos = nbt.m_128469_("pos");
        Vec2i locationInWorld = new Vec2i(pos.m_128451_("x"), pos.m_128451_("y"));
        int range = nbt.m_128451_("range");
        UUID uuid = nbt.m_128342_("owner");
        return new SatelliteData(locationInWorld, range, uuid);
    }
}

