/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.satellite;

import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.api.space.satellite.data.SatelliteData;
import argent_matter.gcyr.common.data.GCYRSatellites;
import argent_matter.gcyr.common.satellite.EmptySatellite;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class Satellite {
    protected SatelliteData data;
    protected ResourceKey<Level> level;
    protected final SatelliteType<?> type;
    protected boolean jammed;
    protected boolean needsRepair;

    public Satellite(SatelliteType<?> type, SatelliteData data, ResourceKey<Level> level) {
        this.type = type;
        this.data = data;
        this.level = level;
    }

    public static <S extends Satellite> Products.P3<RecordCodecBuilder.Mu<S>, SatelliteType<?>, SatelliteData, ResourceKey<Level>> baseCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)GCYRRegistries.SATELLITES.codec().fieldOf("type").forGetter(Satellite::getType), (App)SatelliteData.CODEC.fieldOf("data").forGetter(Satellite::getData), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("level").forGetter(Satellite::getLevel));
    }

    public Satellite copy() {
        Satellite copy = (Satellite)this.type.getDefaultInstance().get();
        copy.data = this.data.copy();
        copy.level = this.level;
        return copy;
    }

    public boolean isNonWorking() {
        return this.jammed || this.needsRepair;
    }

    public abstract void tickSatellite(Level var1);

    public boolean runSatellite(Level level) {
        if (this.jammed || this.needsRepair) {
            return false;
        }
        return this.runSatelliteFunction(level);
    }

    public abstract boolean runSatelliteFunction(Level var1);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", ((ResourceLocation)GCYRRegistries.SATELLITES.getKey(this.type)).toString());
        tag.m_128365_("data", (Tag)this.data.serializeNBT());
        tag.m_128359_("level", this.level.m_135782_().toString());
        Tag extra = this.serializeExtraData();
        if (extra != null) {
            tag.m_128365_("extra", extra);
        }
        return tag;
    }

    @Nullable
    public abstract Tag serializeExtraData();

    public static Satellite deserializeNBT(CompoundTag nbt, Level level) {
        SatelliteType type = (SatelliteType)GCYRRegistries.SATELLITES.get((Object)new ResourceLocation(nbt.m_128461_("id")));
        SatelliteData data = SatelliteData.deserializeNBT(nbt.m_128469_("data"));
        ResourceKey levelResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("level")));
        if (type == null) {
            return new EmptySatellite(GCYRSatellites.EMPTY, data, (ResourceKey<Level>)levelResourceKey);
        }
        SatelliteType.SatelliteFactory satellite = type.getFactory();
        Object sat = satellite.create(type, data, (ResourceKey<Level>)levelResourceKey);
        if (nbt.m_128441_("extra")) {
            ((Satellite)sat).deserializeExtraData(nbt.m_128423_("extra"), level);
        }
        return sat;
    }

    public abstract void deserializeExtraData(Tag var1, Level var2);

    public SatelliteData getData() {
        return this.data;
    }

    public ResourceKey<Level> getLevel() {
        return this.level;
    }

    public SatelliteType<?> getType() {
        return this.type;
    }

    public boolean isJammed() {
        return this.jammed;
    }

    public void setJammed(boolean jammed) {
        this.jammed = jammed;
    }

    public boolean isNeedsRepair() {
        return this.needsRepair;
    }

    public void setNeedsRepair(boolean needsRepair) {
        this.needsRepair = needsRepair;
    }
}

