/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.dyson;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.api.capability.IDysonSystem;
import argent_matter.gcyr.api.space.dyson.DysonSphere;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.common.data.GCYRNetworking;
import argent_matter.gcyr.common.data.GCYRSatellites;
import argent_matter.gcyr.common.networking.s2c.PacketSyncDysonSphereStatus;
import argent_matter.gcyr.common.satellite.DysonSwarmSatellite;
import argent_matter.gcyr.data.loader.PlanetData;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DysonSystemSavedData
extends SavedData
implements IDysonSystem {
    @Nullable
    private DysonSphere currentActiveSunBlock;
    private final Long2ObjectMap<Set<DysonSwarmSatellite>> swarmSatellites = new Long2ObjectOpenHashMap();
    private final ServerLevel level;

    @Nullable
    public static DysonSystemSavedData getOrCreate(ServerLevel originLevel) {
        if (originLevel.m_6042_().f_63856_()) {
            return null;
        }
        ResourceLocation solarSystem = PlanetData.getPlanetFromLevelOrOrbit((ResourceKey<Level>)originLevel.m_46472_()).map(Planet::solarSystem).orElse(null);
        if (solarSystem == null) {
            return null;
        }
        List<Planet> planets = PlanetData.getSolarSystemPlanets(solarSystem);
        if (planets.isEmpty()) {
            DysonSystemSavedData.internalGetOrCreate(originLevel);
        }
        ServerLevel firstWorldLevel = originLevel.m_7654_().m_129880_(planets.get(0).level());
        return DysonSystemSavedData.internalGetOrCreate(Objects.requireNonNullElse(firstWorldLevel, originLevel));
    }

    private static DysonSystemSavedData internalGetOrCreate(ServerLevel serverLevel) {
        return (DysonSystemSavedData)serverLevel.m_8895_().m_164861_(tag -> new DysonSystemSavedData(serverLevel, (CompoundTag)tag), () -> new DysonSystemSavedData(serverLevel), "gcyr_dyson_systems");
    }

    public DysonSystemSavedData(ServerLevel level) {
        this.level = level;
    }

    public DysonSystemSavedData(ServerLevel level, CompoundTag tag) {
        this(level);
        this.load(tag);
    }

    @Override
    @Nullable
    public DysonSphere activeDysonSphere() {
        return this.currentActiveSunBlock;
    }

    @Override
    public boolean isDysonSphereActive() {
        return this.currentActiveSunBlock != null;
    }

    @Override
    public int activeDysonSwarmSatelliteCount() {
        return this.swarmSatellites.values().stream().mapToInt(Collection::size).sum();
    }

    @Override
    public void addDysonSphere(BlockPos controllerPos) {
        if (this.currentActiveSunBlock != null) {
            return;
        }
        this.currentActiveSunBlock = new DysonSphere(controllerPos, this);
        this.swarmSatellites.keySet().forEach(pos -> this.disableAllDysonSatellites(BlockPos.m_122022_((long)pos)));
        this.m_77762_();
        for (ServerPlayer player : this.level.m_7654_().m_6846_().m_11314_()) {
            Planet playerPlanet = PlanetData.getPlanetFromLevel((ResourceKey<Level>)player.m_284548_().m_46472_()).orElse(null);
            Planet thisPlanet = PlanetData.getPlanetFromLevel((ResourceKey<Level>)this.level.m_46472_()).orElse(null);
            if (playerPlanet == null || thisPlanet == null || !playerPlanet.solarSystem().equals((Object)thisPlanet.solarSystem())) continue;
            GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(false), player);
        }
    }

    @Override
    public void disableDysonSphere(BlockPos controllerPos) {
        if (this.currentActiveSunBlock != null && controllerPos.equals((Object)this.currentActiveSunBlock.getControllerPos())) {
            this.currentActiveSunBlock.setControllerPos(null);
            this.m_77762_();
            for (ServerPlayer player : this.level.m_7654_().m_6846_().m_11314_()) {
                Planet playerPlanet = PlanetData.getPlanetFromLevel((ResourceKey<Level>)player.m_284548_().m_46472_()).orElse(null);
                Planet thisPlanet = PlanetData.getPlanetFromLevel((ResourceKey<Level>)this.level.m_46472_()).orElse(null);
                if (playerPlanet == null || thisPlanet == null || !playerPlanet.solarSystem().equals((Object)thisPlanet.solarSystem())) continue;
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(false), player);
            }
        }
    }

    @Override
    public void addDysonSatellite(BlockPos controllerPos, DysonSwarmSatellite satellite) {
        ((Set)this.swarmSatellites.computeIfAbsent(controllerPos.m_121878_(), pos -> new HashSet())).add(satellite);
        this.m_77762_();
    }

    @Override
    public void disableAllDysonSatellites(BlockPos controllerPos) {
        this.swarmSatellites.remove(controllerPos.m_121878_());
        this.m_77762_();
    }

    @Override
    public void tick() {
        if (this.currentActiveSunBlock != null) {
            this.currentActiveSunBlock.tick(this.level);
        }
    }

    @Override
    public void setChanged() {
        this.m_77762_();
    }

    public void load(CompoundTag arg) {
        if (arg.m_128425_("dysonSphere", 10)) {
            this.currentActiveSunBlock = DysonSphere.load(arg.m_128469_("dysonSphere"), this);
            for (ServerPlayer player : this.level.m_6907_()) {
                GCYRNetworking.NETWORK.sendToPlayer((IPacket)new PacketSyncDysonSphereStatus(true), player);
            }
        }
        CompoundTag stationsTag = arg.m_128469_("satellites");
        for (String name : stationsTag.m_128431_()) {
            ListTag tag = stationsTag.m_128437_(name, 10);
            long pos = Long.parseLong(name);
            for (int i = 0; i < tag.size(); ++i) {
                DysonSwarmSatellite satellite = (DysonSwarmSatellite)GCYRSatellites.DYSON_SWARM.getCodec().parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128728_(i)).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0));
                ((Set)this.swarmSatellites.computeIfAbsent(pos, $ -> new HashSet())).add(satellite);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag tag;
        if (this.currentActiveSunBlock != null) {
            tag = new CompoundTag();
            this.currentActiveSunBlock.save(tag);
            compoundTag.m_128365_("dysonSphere", (Tag)tag);
        }
        tag = new CompoundTag();
        for (Long2ObjectMap.Entry entry : this.swarmSatellites.long2ObjectEntrySet()) {
            ListTag pos = new ListTag();
            for (DysonSwarmSatellite satellite : (Set)entry.getValue()) {
                Tag station = (Tag)GCYRSatellites.DYSON_SWARM.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, (Object)satellite).result().orElseThrow();
                pos.add((Object)station);
            }
            tag.m_128365_(Long.toString(entry.getLongKey()), (Tag)pos);
        }
        compoundTag.m_128365_("satellites", (Tag)tag);
        return compoundTag;
    }
}

