/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.dyson;

import argent_matter.gcyr.api.capability.IDysonSystem;
import com.gregtechceu.gtceu.api.GTValues;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;

public class DysonSphere {
    private final int MINIMUM_MAINTENANCE_TIME = 3456000;
    private final float BASE_COLLAPSE_CHANCE = 5.0E-5f;
    private final IDysonSystem system;
    private BlockPos controllerPos;
    private int timeActive = 0;
    private int timeNeededMaintenance = 0;
    private boolean needsMaintenance;
    private boolean collapsed;

    public DysonSphere(BlockPos controllerPos, IDysonSystem system) {
        this.controllerPos = controllerPos;
        this.system = system;
    }

    public void tick(ServerLevel level) {
        if (level.m_46467_() % 20L == 0L) {
            if (this.isCollapsed()) {
                return;
            }
            if (this.isNeedsMaintenance()) {
                if (GTValues.RNG.m_188501_() <= 5.0E-5f * (float)this.timeNeededMaintenance) {
                    this.setCollapsed();
                }
                ++this.timeNeededMaintenance;
                this.system.setChanged();
                return;
            }
            if (this.calculateTime(20) && GTValues.RNG.m_188501_() - 0.75f >= 0.0f) {
                this.needsMaintenance();
            }
        }
    }

    public float getCollapseChance() {
        return 5.0E-5f * (float)this.timeNeededMaintenance;
    }

    public void needsMaintenance() {
        this.needsMaintenance = true;
        ++this.timeNeededMaintenance;
        this.system.setChanged();
    }

    public void fixMaintenance() {
        this.needsMaintenance = false;
        this.timeNeededMaintenance = 0;
        this.system.setChanged();
    }

    public void setCollapsed() {
        this.setCollapsed(true);
        this.system.disableDysonSphere(this.controllerPos);
    }

    private boolean calculateTime(int timeSinceLastTick) {
        this.setTimeActive(timeSinceLastTick + this.getTimeActive());
        this.system.setChanged();
        int value = this.getTimeActive() - 3456000;
        if (value > 0) {
            this.setTimeActive(value);
            return true;
        }
        return false;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.system.setChanged();
    }

    public void save(CompoundTag tag) {
        if (this.controllerPos != null) {
            tag.m_128365_("controllerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        tag.m_128379_("needsMaintenance", this.isNeedsMaintenance());
        tag.m_128379_("collapsed", this.isCollapsed());
        tag.m_128405_("timeActive", this.timeActive);
        tag.m_128405_("timeNeededMaintenance", this.timeNeededMaintenance);
    }

    public static DysonSphere load(CompoundTag tag, IDysonSystem system) {
        BlockPos controllerPos = tag.m_128425_("controllerPos", 10) ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("controllerPos")) : null;
        boolean needsMaintenance = tag.m_128471_("needsMaintenance");
        boolean collapsed = tag.m_128471_("collapsed");
        int timeActive = tag.m_128451_("timeActive");
        int timeNeededMaintenance = tag.m_128451_("timeNeededMaintenance");
        DysonSphere sphere = new DysonSphere(controllerPos, system);
        sphere.needsMaintenance = needsMaintenance;
        sphere.setCollapsed(collapsed);
        sphere.setTimeActive(timeActive);
        sphere.setTimeNeededMaintenance(timeNeededMaintenance);
        return sphere;
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public int getTimeActive() {
        return this.timeActive;
    }

    public int getTimeNeededMaintenance() {
        return this.timeNeededMaintenance;
    }

    public void setTimeActive(int timeActive) {
        this.timeActive = timeActive;
    }

    public void setTimeNeededMaintenance(int timeNeededMaintenance) {
        this.timeNeededMaintenance = timeNeededMaintenance;
    }

    public boolean isNeedsMaintenance() {
        return this.needsMaintenance;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }
}

