/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.mixin;

import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.api.syncdata.entity.IAutoPersistEntity;
import argent_matter.gcyr.api.syncdata.entity.IManagedEntity;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.util.PlatformUtils;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void gcyr$tick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (entity.m_20186_() < (double)level2.m_141937_() && PlanetData.isOrbitLevel((ResourceKey<Level>)level2.m_46472_())) {
            ServerLevel newLevel = level2.m_7654_().m_129880_(PlanetData.getPlanetFromOrbit((ResourceKey<Level>)level2.m_46472_()).map(Planet::level).orElse(Level.f_46428_));
            Entity newEntity = PlatformUtils.changeDimension(entity, newLevel);
            newEntity.m_6034_(newEntity.m_20185_(), 600.0, newEntity.m_20189_());
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private void gcyr$addAdditionalSaveData(CompoundTag compound, CallbackInfoReturnable<Boolean> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof IAutoPersistEntity) {
            IAutoPersistEntity autoPersistEntity = (IAutoPersistEntity)((Object)entityMixin);
            autoPersistEntity.saveManagedPersistentData(compound);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void gcyr$load(CompoundTag compound, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof IAutoPersistBlockEntity) {
            IAutoPersistBlockEntity autoPersistBlockEntity = (IAutoPersistBlockEntity)entityMixin;
            autoPersistBlockEntity.loadManagedPersistentData(compound);
        }
    }

    @Inject(method={"unsetRemoved"}, at={@At(value="RETURN")})
    private void injectClearRemoved(CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof IManagedEntity) {
            IManagedEntity managed = (IManagedEntity)((Object)entityMixin);
            managed.getRootStorage().init();
        }
    }
}

