/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.data.loader;

import argent_matter.gcyr.GCYR;
import argent_matter.gcyr.GCYRClient;
import argent_matter.gcyr.api.space.planet.Galaxy;
import argent_matter.gcyr.api.space.planet.PlanetRing;
import argent_matter.gcyr.api.space.planet.PlanetSkyRenderer;
import argent_matter.gcyr.api.space.planet.SolarSystem;
import argent_matter.gcyr.client.dimension.ClientModSkies;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class PlanetResources
implements ResourceManagerReloadListener {
    public static final PlanetResources INSTANCE = new PlanetResources();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();

    public void m_6213_(ResourceManager manager) {
        JsonObject jsonObject;
        InputStreamReader reader;
        ArrayList<PlanetSkyRenderer> skyRenderers = new ArrayList<PlanetSkyRenderer>();
        ArrayList<SolarSystem> solarSystems = new ArrayList<SolarSystem>();
        ArrayList<PlanetRing> planetRings = new ArrayList<PlanetRing>();
        ArrayList<Galaxy> galaxies = new ArrayList<Galaxy>();
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/sky_renderers", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    skyRenderers.add((PlanetSkyRenderer)PlanetSkyRenderer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry sky rendering assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/solar_systems", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    solarSystems.add((SolarSystem)SolarSystem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry solar system assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/planet_rings", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    planetRings.add((PlanetRing)PlanetRing.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry planet ring assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (ResourceLocation id : manager.m_214159_("gcyr/planet_assets/galaxies", path -> path.m_135815_().endsWith(".json")).keySet()) {
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    reader = new InputStreamReader(resource.m_215507_());
                    jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    galaxies.add((Galaxy)Galaxy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)GCYR.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                GCYR.LOGGER.error("Failed to load Gregicality Rocketry galaxy assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        solarSystems.sort(Comparator.comparing(SolarSystem::solarSystem));
        galaxies.sort(Comparator.comparing(Galaxy::galaxy));
        GCYRClient.skyRenderers = skyRenderers;
        GCYRClient.solarSystems = solarSystems;
        GCYRClient.planetRings = planetRings;
        GCYRClient.galaxies = galaxies;
        ClientModSkies.register();
    }
}

