/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.satellite;

import argent_matter.gcyr.api.capability.IGpsTracked;
import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.api.space.satellite.data.SatelliteData;
import argent_matter.gcyr.util.Vec2i;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GpsSatellite
extends Satellite {
    public static final Codec<GpsSatellite> CODEC = RecordCodecBuilder.create(instance -> Satellite.baseCodec(instance).apply((Applicative)instance, GpsSatellite::new));
    public static Map<Level, Set<Entity>> trackedEntities = new LinkedHashMap<Level, Set<Entity>>();
    private Set<Entity> lastTrackedEntities = new HashSet<Entity>();

    public GpsSatellite(SatelliteType<?> type, SatelliteData data, ResourceKey<Level> level) {
        super(type, data, level);
    }

    @Override
    public void tickSatellite(Level level) {
        if (this.isNonWorking()) {
            return;
        }
        Vec2i pos = this.data.locationInWorld();
        Set set = level.m_45933_(null, AABB.m_165882_((Vec3)new Vec3((double)pos.x(), (double)level.m_5736_(), (double)pos.y()), (double)this.data.range(), (double)100.0, (double)this.data.range())).stream().filter(ent -> ((IGpsTracked)ent).isGpsTracked()).collect(Collectors.toSet());
        this.lastTrackedEntities.removeAll(set);
        Set<Entity> tracked = trackedEntities.get(level);
        tracked.removeAll(this.lastTrackedEntities);
        tracked.addAll(set);
        this.lastTrackedEntities = tracked;
    }

    @Override
    public boolean runSatelliteFunction(Level level) {
        return false;
    }

    @Nullable
    public ListTag serializeExtraData() {
        ListTag tracked = new ListTag();
        for (Entity entity : this.lastTrackedEntities) {
            tracked.add((Object)StringTag.m_129297_((String)entity.m_20148_().toString()));
        }
        return tracked;
    }

    @Override
    public void deserializeExtraData(Tag nbt, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ListTag list = (ListTag)nbt;
            for (Tag tag : list) {
                StringTag str = (StringTag)tag;
                UUID uuid = UUID.fromString(str.m_7916_());
                Entity ent = serverLevel.m_8791_(uuid);
                if (ent == null) continue;
                this.lastTrackedEntities.add(ent);
            }
        }
    }
}

