/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.machine.multiblock.electric;

import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.IDysonSystem;
import argent_matter.gcyr.common.data.GCYRParticles;
import argent_matter.gcyr.config.GCYRConfig;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DysonSystemControllerMachine
extends WorkableElectricMultiblockMachine {
    public DysonSystemControllerMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        if (!this.isRemote()) {
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel());
            if (system == null || !system.isDysonSphereActive()) {
                return;
            }
            system.activeDysonSphere().setControllerPos(null);
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        if (!this.isRemote()) {
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel());
            if (system == null) {
                return;
            }
            if (system.isDysonSphereActive() && system.activeDysonSphere().getControllerPos() == null) {
                system.activeDysonSphere().setControllerPos(this.getPos());
            } else if (!system.isDysonSphereActive()) {
                system.addDysonSphere(this.getPos());
            }
        }
    }

    @Nullable
    protected GTRecipe getRealRecipe(GTRecipe recipe) {
        IDysonSystem system;
        if (this.getLevel().m_6042_().f_63856_()) {
            return null;
        }
        if (recipe.data.m_128441_("gcyr:repair_dyson_sphere") && (system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel())) != null && system.isDysonSphereActive() && (!system.activeDysonSphere().isNeedsMaintenance() || !this.getPos().equals((Object)system.activeDysonSphere().getControllerPos()))) {
            return null;
        }
        return super.getRealRecipe(recipe);
    }

    public boolean onWorking() {
        boolean value = super.onWorking();
        Level level = this.getLevel();
        Direction frontFacing = this.getFrontFacing();
        Direction backFacing = frontFacing.m_122424_();
        Direction rightFacing = frontFacing.m_122427_();
        BlockPos pos = this.getPos().m_122032_().m_122175_(backFacing, 4).m_122175_(rightFacing, 1).m_122184_(0, 263, 0).m_7949_();
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)3.0, (double)512.0, (double)3.0), EntitySelector.f_20403_)) {
            entity.m_6469_(GTDamageTypes.ELECTRIC.source((LevelAccessor)level), GCYRConfig.INSTANCE.machine.dysonControllerBeamDamage);
        }
        return value;
    }

    public void afterWorking() {
        super.afterWorking();
        GTRecipe recipe = this.getRecipeLogic().getLastRecipe();
        if (recipe == null || this.isRemote()) {
            return;
        }
        if (recipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP).isEmpty()) {
            return;
        }
        IDysonSystem system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel());
        if (system == null) {
            return;
        }
        if (!system.isDysonSphereActive() && recipe.data.m_128441_("gcyr:launch_dyson_sphere")) {
            system.addDysonSphere(this.getPos());
        } else if (system.isDysonSphereActive() && recipe.data.m_128441_("gcyr:repair_dyson_sphere") && system.activeDysonSphere().getControllerPos().equals((Object)this.getPos())) {
            system.activeDysonSphere().fixMaintenance();
        }
    }

    public void animateTick(RandomSource random) {
        if (this.isActive() && this.getOffsetTimer() % 20L == 0L) {
            Level level = this.getLevel();
            Direction frontFacing = this.getFrontFacing();
            Direction backFacing = frontFacing.m_122424_();
            Direction rightFacing = frontFacing.m_122427_();
            BlockPos pos = this.getPos().m_122032_().m_122175_(backFacing, 4).m_122175_(rightFacing, 1).m_122184_(0, 9, 0).m_7949_();
            double x = (double)pos.m_123341_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            for (int y = pos.m_123342_(); y < 512; y += 2) {
                level.m_6485_((ParticleOptions)GCYRParticles.DYSON_BEAM, true, x, (double)y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (!this.isFormed) {
            return;
        }
        if (!this.isRemote()) {
            IDysonSystem system = GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel());
            if (system == null) {
                return;
            }
            if (system.isDysonSphereActive()) {
                if (system.activeDysonSphere().isNeedsMaintenance() && !system.activeDysonSphere().isCollapsed()) {
                    textList.add((Component)Component.m_237115_((String)"menu.gcyr.dyson_sphere.needs_maintenance").m_130940_(this.getOffsetTimer() % 10L >= 5L ? ChatFormatting.RED : ChatFormatting.DARK_RED));
                    textList.add((Component)Component.m_237110_((String)"menu.gcyr.dyson_sphere.time_since_needed_maintenance", (Object[])new Object[]{system.activeDysonSphere().getTimeNeededMaintenance()}));
                    textList.add((Component)Component.m_237110_((String)"menu.gcyr.dyson_sphere.implosion_chance", (Object[])new Object[]{Float.valueOf(system.activeDysonSphere().getCollapseChance() * 100.0f)}));
                } else if (system.activeDysonSphere().isCollapsed()) {
                    textList.add((Component)Component.m_237115_((String)"menu.gcyr.dyson_sphere.collapsed"));
                }
            }
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            if (componentData.equals("dbg_start_sphere")) {
                GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel()).addDysonSphere(this.getPos());
            } else if (componentData.equals("dbg_delete_sphere")) {
                GCYRCapabilityHelper.getDysonSystem((ServerLevel)this.getLevel()).disableDysonSphere(this.getPos());
            }
        }
    }
}

