/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.entity.data;

import argent_matter.gcyr.common.entity.data.EntityOxygenSystem;
import argent_matter.gcyr.common.item.armor.SpaceSuitArmorItem;
import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.data.recipe.GCYRTags;
import java.util.stream.StreamSupport;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;

public class EntityTemperatureSystem {
    public static final UniformInt TEMP_RANGE = UniformInt.m_146622_((int)213, (int)333);

    public static void temperatureTick(LivingEntity entity, ServerLevel level) {
        if (!GCYRConfig.INSTANCE.server.enableOxygen) {
            return;
        }
        if (!entity.m_6095_().equals(EntityType.f_20524_)) {
            if (entity.m_21222_()) {
                return;
            }
            if (entity.m_6095_().m_204039_(GCYRTags.IGNORE_TEMPERATURE)) {
                return;
            }
        }
        float temperature = PlanetData.getWorldTemperature((Level)level);
        if (EntityOxygenSystem.inDistributorBubble((Level)level, entity.m_20183_())) {
            temperature = 293.0f;
        }
        UniformInt temperatureResistance = TEMP_RANGE;
        if (SpaceSuitArmorItem.hasFullSet(entity)) {
            temperatureResistance = SpaceSuitArmorItem.getTemperatureThreshold();
        }
        if (temperature > (float)temperatureResistance.m_142737_() && !entity.m_5825_() && !entity.m_21023_(MobEffects.f_19607_) && !EntityTemperatureSystem.armourIsHeatResistant(entity)) {
            EntityTemperatureSystem.burnEntity(entity);
        } else if (temperature < (float)temperatureResistance.m_142739_() && !EntityTemperatureSystem.armourIsFreezeResistant(entity)) {
            EntityTemperatureSystem.freezeEntity(entity, level);
        }
    }

    private static void burnEntity(LivingEntity entity) {
        entity.m_6469_(entity.m_269291_().m_269549_(), GCYRConfig.INSTANCE.server.heatDamage);
        entity.m_20254_(10);
    }

    private static void freezeEntity(LivingEntity entity, ServerLevel level) {
        entity.m_6469_(entity.m_269291_().m_269109_(), GCYRConfig.INSTANCE.server.freezeDamage);
        entity.m_146917_(Math.min(entity.m_146891_() + 20, entity.m_146888_() + 50));
        RandomSource random = entity.m_9236_().m_213780_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), (double)(Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336f), 0.05, (double)Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336);
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            skeleton.m_21406_(EntityType.f_20481_, true);
        }
    }

    public static boolean armourIsFreezeResistant(LivingEntity entity) {
        return StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(s -> s.m_204117_(GCYRTags.FREEZE_RESISTANT));
    }

    public static boolean armourIsHeatResistant(LivingEntity entity) {
        return StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(s -> s.m_204117_(GCYRTags.HEAT_RESISTANT));
    }
}

