/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.entity;

import argent_matter.gcyr.api.block.IRocketPart;
import argent_matter.gcyr.api.capability.GCYRCapabilityHelper;
import argent_matter.gcyr.api.capability.ISpaceStationHolder;
import argent_matter.gcyr.api.gui.factory.EntityUIFactory;
import argent_matter.gcyr.api.registries.GCYRRegistries;
import argent_matter.gcyr.api.space.planet.Planet;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.api.space.station.SpaceStation;
import argent_matter.gcyr.common.block.FuelTankBlock;
import argent_matter.gcyr.common.block.RocketMotorBlock;
import argent_matter.gcyr.common.data.GCYRBlocks;
import argent_matter.gcyr.common.data.GCYREntityDataSerializers;
import argent_matter.gcyr.common.data.GCYRItems;
import argent_matter.gcyr.common.data.GCYRRecipeTypes;
import argent_matter.gcyr.common.data.GCYRSoundEntries;
import argent_matter.gcyr.common.entity.data.EntityOxygenSystem;
import argent_matter.gcyr.common.entity.data.EntityTemperatureSystem;
import argent_matter.gcyr.common.item.KeyCardBehaviour;
import argent_matter.gcyr.common.item.PlanetIdChipBehaviour;
import argent_matter.gcyr.common.item.SatelliteItemBehaviour;
import argent_matter.gcyr.common.item.StationContainerBehaviour;
import argent_matter.gcyr.config.GCYRConfig;
import argent_matter.gcyr.data.loader.PlanetData;
import argent_matter.gcyr.data.recipe.GCYRTags;
import argent_matter.gcyr.mixin.LivingEntityAccessor;
import argent_matter.gcyr.util.PlatformUtils;
import argent_matter.gcyr.util.PosWithState;
import com.google.common.collect.Sets;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RocketEntity
extends Entity
implements HasCustomInventoryScreen,
IUIHolder,
PlayerRideable,
IEntityAdditionalSpawnData {
    public static final Object2BooleanMap<Fluid> FUEL_CACHE = new Object2BooleanOpenHashMap();
    public static final EntityDataAccessor<Boolean> ROCKET_STARTED = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Long> FUEL_CAPACITY = SynchedEntityData.m_135353_(RocketEntity.class, GCYREntityDataSerializers.LONG);
    public static final EntityDataAccessor<Long> FUEL_AMOUNT = SynchedEntityData.m_135353_(RocketEntity.class, GCYREntityDataSerializers.LONG);
    public static final EntityDataAccessor<Integer> THRUSTER_COUNT = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WEIGHT = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RECIPE_DURATION = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> START_TIMER = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<List<PosWithState>> POSITIONED_STATES = SynchedEntityData.m_135353_(RocketEntity.class, GCYREntityDataSerializers.POSITIONED_BLOCK_STATE_LIST);
    public static final EntityDataAccessor<BlockPos> SIZE = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<List<BlockPos>> SEAT_POSITIONS = SynchedEntityData.m_135353_(RocketEntity.class, GCYREntityDataSerializers.BLOCK_POS_LIST);
    public static final EntityDataAccessor<Optional<Planet>> DESTINATION = SynchedEntityData.m_135353_(RocketEntity.class, GCYREntityDataSerializers.PLANET);
    private final FluidStorage fuelTank;
    private final ItemStackTransfer configSlot;
    private final ItemStackTransfer satelliteSlot;
    private boolean destinationIsSpaceStation;
    private final Object2IntMap<IRocketPart> partCounts = new Object2IntOpenHashMap();
    @Nullable
    private GlobalPos lastPos;
    private boolean returnToStart;
    private SatelliteType<?> satelliteToLaunch;
    private int motorTiersTotal;
    private int fuelTankTiersTotal;
    private int motorTier;
    private int fuelTankTier;
    private int partsTier;
    private double speed;
    @Nullable
    private GTRecipe selectedFuelRecipe;
    private final Set<BlockPos> thrusterPositions = new HashSet<BlockPos>();
    private ThreadLocal<Boolean> hasRequestedBlockSync = ThreadLocal.withInitial(() -> false);

    public RocketEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.configSlot = new ItemStackTransfer(1);
        this.configSlot.setFilter(stack -> GCYRItems.ID_CHIP.isIn(stack) || GCYRItems.KEYCARD.isIn(stack));
        this.satelliteSlot = new ItemStackTransfer(1);
        this.satelliteSlot.setFilter(stack -> GCYRItems.SPACE_STATION_PACKAGE.isIn(stack) || stack.m_204117_(GCYRTags.SATELLITES));
        this.fuelTank = new FluidStorage(0L, fluid -> FUEL_CACHE.computeIfAbsent((Object)fluid.getFluid(), f -> this.m_20194_().m_129894_().m_44013_((RecipeType)GCYRRecipeTypes.ROCKET_FUEL_RECIPES).stream().anyMatch(recipe -> {
            if (RecipeHelper.getInputEUt((GTRecipe)recipe) > (long)this.motorTier) {
                return false;
            }
            List list = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
            if (!list.isEmpty()) {
                return Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).anyMatch(stack -> stack.getFluid() == f);
            }
            return false;
        })));
        this.fuelTank.setOnContentsChanged(() -> {
            List list;
            this.f_19804_.m_135381_(FUEL_AMOUNT, (Object)this.fuelTank.getFluidAmount());
            if (this.selectedFuelRecipe != null && !(list = this.selectedFuelRecipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList())).isEmpty() && Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).anyMatch(stack -> stack.isFluidEqual(this.fuelTank.getFluid()))) {
                return;
            }
            this.selectedFuelRecipe = this.m_20194_().m_129894_().m_44013_((RecipeType)GCYRRecipeTypes.ROCKET_FUEL_RECIPES).stream().filter(recipe -> {
                List list = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
                if (!list.isEmpty()) {
                    return Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).anyMatch(stack -> stack.isFluidEqual(this.fuelTank.getFluid()));
                }
                return false;
            }).findFirst().orElse(null);
            if (this.selectedFuelRecipe != null) {
                this.setRecipeDuration(this.selectedFuelRecipe.duration);
            }
        });
    }

    public void reinitializeFluidStorage() {
        this.fuelTank.setCapacity(this.getFuelCapacity());
    }

    public void m_8119_() {
        super.m_8119_();
        this.rotateRocket();
        this.burnEntities();
        boolean started = (Boolean)this.f_19804_.m_135370_(ROCKET_STARTED);
        if (started && this.consumeFuel()) {
            this.spawnParticles();
            if (this.countdown()) {
                this.flightMovement();
                this.goToDestination();
            }
        } else if (!started) {
            this.fall();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    protected AABB m_142242_() {
        Vec3 pos = this.m_20182_();
        BlockPos size = (BlockPos)this.f_19804_.m_135370_(SIZE);
        double x = size.m_123341_() + 1;
        double y = size.m_123342_() + 1;
        double z = size.m_123343_() + 1;
        return new AABB(pos.f_82479_, pos.f_82480_, pos.f_82481_, pos.f_82479_ + x, pos.f_82480_ + y, pos.f_82481_ + z);
    }

    public void m_6210_() {
        Vec3 pos = this.m_20182_();
        super.m_6210_();
        this.m_146884_(pos);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        InteractionResult result = InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        if (!this.m_9236_().f_46443_) {
            if (player.m_36341_()) {
                this.m_213583_(player);
                return InteractionResult.CONSUME;
            }
            player.m_20329_((Entity)this);
            return result;
        }
        return result;
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).widget((Widget)new LabelWidget(7, 7, this.m_5446_().getString())).widget((Widget)new TankWidget((IFluidStorage)this.fuelTank, 16, 20, 20, 58, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_TANK_BACKGROUND).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP)).widget((Widget)new SlotWidget((IItemTransfer)this.configSlot, 0, 40, 20)).widget((Widget)new SlotWidget((IItemTransfer)this.satelliteSlot, 0, 60, 20)).widget((Widget)new ButtonWidget(40, 60, 38, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON.copy().setColor(-5636096), new TextTexture("menu.gcyr.launch")}), clickData -> this.startRocket())).widget((Widget)new ButtonWidget(40, 40, 38, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON.copy().setColor(-2049792), new TextTexture("menu.gcyr.rocket.unbuild")}), clickData -> this.unBuild())).widget((Widget)new LabelWidget(84, 25, this.getDisplayThrust())).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)7, (int)84, (boolean)true)).background(new IGuiTexture[]{GuiTextures.BACKGROUND});
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EntityUIFactory.INSTANCE.openUI((Object)this, serverPlayer);
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return this.getSeatPositions().size();
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            int passengerIndex = this.m_20197_().indexOf(passenger);
            if (this.getSeatPositions().isEmpty()) {
                passenger.m_8127_();
                return;
            }
            BlockPos seatPos = this.getSeatPositions().get(passengerIndex);
            callback.m_20372_(passenger, this.m_20185_() + (double)seatPos.m_123341_() + 0.5, this.m_20186_() + (double)seatPos.m_123342_() - 0.5, this.m_20189_() + (double)seatPos.m_123343_() + 0.5);
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Vec3[] escapeVectors = new Vec3[]{RocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)livingEntity.m_146908_()), RocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 22.5f)), RocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 22.5f)), RocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 45.0f)), RocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double maxY = this.m_20191_().f_82292_;
        double minY = this.m_20191_().f_82289_ - 0.5;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Vec3 vector : escapeVectors) {
            mutableBlockPos.m_122169_(this.m_20185_() + vector.f_82479_, maxY, this.m_20189_() + vector.f_82481_);
            for (double d = maxY; d > minY; d -= 1.0) {
                set.add(mutableBlockPos.m_7949_());
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double floor;
            if (this.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13132_) || !DismountHelper.m_38439_((double)(floor = this.m_9236_().m_45573_(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.m_82514_((Vec3i)blockpos, (double)floor);
            for (Pose pose : livingEntity.m_7431_()) {
                if (!DismountHelper.m_38439_((double)this.m_9236_().m_45573_(blockpos))) continue;
                livingEntity.m_20124_(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.m_20185_(), this.m_20191_().f_82292_, this.m_20189_());
    }

    public void spawnParticles() {
        Vec3 vec = this.m_20184_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos pos : this.thrusterPositions) {
                if (this.getStartTimer() >= 200) {
                    for (ServerPlayer p : serverLevel.m_7654_().m_6846_().m_11314_()) {
                        serverLevel.m_8624_(p, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() - vec.f_82479_ + (double)pos.m_123341_() + 0.5, this.m_20186_() - vec.f_82480_ - 2.2 + (double)pos.m_123342_() + 0.5, this.m_20189_() - vec.f_82481_ + (double)pos.m_123343_() + 0.5, 20, 0.1, 0.1, 0.1, 0.001);
                        serverLevel.m_8624_(p, (ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_() - vec.f_82479_ + (double)pos.m_123341_() + 0.5, this.m_20186_() - vec.f_82480_ - 3.2 + (double)pos.m_123342_() + 0.5, this.m_20189_() - vec.f_82481_ + (double)pos.m_123343_() + 0.5, 10, 0.1, 0.1, 0.1, 0.04);
                    }
                    continue;
                }
                for (ServerPlayer p : serverLevel.m_7654_().m_6846_().m_11314_()) {
                    serverLevel.m_8624_(p, (ParticleOptions)ParticleTypes.f_123777_, true, this.m_20185_() - vec.f_82479_ + (double)pos.m_123341_() + 0.5, this.m_20186_() - vec.f_82480_ - 0.1 + (double)pos.m_123342_() + 0.5, this.m_20189_() - vec.f_82481_ + (double)pos.m_123343_() + 0.5, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
    }

    @Nullable
    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    public void rotateRocket() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null) {
            if (player.f_20900_ > 0.0f) {
                RocketEntity.setEntityRotation(this, 1.0f);
            }
            if (player.f_20900_ < 0.0f) {
                RocketEntity.setEntityRotation(this, -1.0f);
            }
        }
    }

    public long computeRequiredFuelAmountForDestination(@Nullable Planet destination) {
        Planet current = PlanetData.getPlanetFromLevelOrOrbit((ResourceKey<Level>)this.m_9236_().m_46472_()).orElse(null);
        if (current == null || destination == null) {
            return (long)((double)this.getFuelCapacity() * 0.85);
        }
        if (destination.parentWorld() == current.level() || current.parentWorld() == destination.level() || current == destination) {
            return GCYRConfig.INSTANCE.rocket.moonFuelAmount;
        }
        if (current.solarSystem().equals((Object)destination.solarSystem())) {
            return GCYRConfig.INSTANCE.rocket.solarSystemFuelAmount;
        }
        if (current.galaxy().equals((Object)destination.galaxy())) {
            return GCYRConfig.INSTANCE.rocket.galaxyFuelAmount;
        }
        return GCYRConfig.INSTANCE.rocket.anywhereFuelAmount;
    }

    public void startRocket() {
        if (this.isRemote()) {
            return;
        }
        Player player = this.getFirstPlayerPassenger();
        if (player == null) {
            return;
        }
        SynchedEntityData data = this.m_20088_();
        ItemStack config = this.configSlot.getStackInSlot(0);
        if (!config.m_41619_()) {
            if (((Boolean)data.m_135370_(ROCKET_STARTED)).booleanValue()) {
                return;
            }
            if (GCYRItems.ID_CHIP.isIn(config)) {
                this.setDestination(PlanetIdChipBehaviour.getPlanetFromStack(config));
            } else if (GCYRItems.KEYCARD.isIn(config)) {
                this.setDestination(KeyCardBehaviour.getSavedPlanet(config));
            }
            if (this.partsTier < this.getDestination().rocketTier()) {
                RocketEntity.sendVehicleNotGoodEnoughMessage(player, this.getDestination().rocketTier());
                return;
            }
            long requiredFuel = this.computeRequiredFuelAmountForDestination(this.getDestination());
            if (this.fuelTank.getFluidAmount() < requiredFuel) {
                RocketEntity.sendVehicleHasNoFuelMessage(player, this.fuelTank.getFluidAmount(), requiredFuel);
                return;
            }
            if (PlanetIdChipBehaviour.getSpaceStationId(config) != null || KeyCardBehaviour.getSavedStation(config) != null) {
                this.destinationIsSpaceStation = true;
            }
            if (!this.destinationIsSpaceStation && this.m_9236_().m_46472_() == this.getDestination().level()) {
                return;
            }
            data.m_135381_(ROCKET_STARTED, (Object)true);
            this.m_9236_().m_6269_(null, (Entity)this, GCYRSoundEntries.ROCKET.getMainEvent(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            RocketEntity.sendVehicleHasInvalidIdMessage(player);
        }
    }

    public boolean countdown() {
        int timer = this.getStartTimer();
        if (timer < 200) {
            this.setStartTimer(timer + 1);
        }
        return timer == 200;
    }

    public void flightMovement() {
        Vec3 vec = this.m_20184_();
        if (this.speed < this.getRocketSpeed() - 0.01) {
            this.speed += 0.05;
        }
        this.m_20334_(vec.f_82479_, this.speed, vec.f_82481_);
    }

    public void fall() {
        if (this.m_20068_()) {
            return;
        }
        Vec3 delta = this.m_20184_();
        if (delta.f_82480_ > -2.0) {
            delta = delta.m_82520_(0.0, -0.08, 0.0);
        }
        this.m_20256_(delta);
        if (this.m_6688_() != null && ((LivingEntityAccessor)this.m_6688_()).isJumping() && this.consumeFuel()) {
            this.m_20334_(delta.f_82479_, Math.min(delta.f_82480_ + 0.05, -0.25), delta.f_82481_);
            this.f_19789_ *= 0.9f;
            this.spawnParticles();
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (GCYRConfig.INSTANCE.rocket.doCrashLandingExplosion && fallDistance > 48.0f && this.m_20096_()) {
            Vec3 bbCenter = this.m_20191_().m_82399_();
            this.m_9236_().m_255391_((Entity)this, bbCenter.f_82479_, this.m_20191_().f_82289_, bbCenter.f_82481_, 10.0f, EntityOxygenSystem.levelHasOxygen(this.m_9236_()), Level.ExplosionInteraction.MOB);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public void burnEntities() {
        if (this.getStartTimer() == 200) {
            BlockPos size = (BlockPos)this.f_19804_.m_135370_(SIZE);
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_() + (double)((float)size.m_123341_() / 2.0f), this.m_20186_() - 2.0, this.m_20189_() + (double)((float)size.m_123343_() / 2.0f)), (double)(size.m_123341_() + 2), (double)2.0, (double)(size.m_123343_() + 2));
            List entities = this.m_20193_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                if (entity.m_5825_() || entity.m_21023_(MobEffects.f_19607_) || EntityTemperatureSystem.armourIsHeatResistant(entity)) continue;
                entity.m_20254_(15);
            }
        }
    }

    private boolean doesDrop(BlockState state, BlockPos pos) {
        if (this.m_20096_()) {
            BlockState state2 = this.m_9236_().m_8055_(new BlockPos((int)Math.floor(this.m_20185_()), (int)(this.m_20186_() - 0.2), (int)Math.floor(this.m_20189_())));
            if (!(this.m_9236_().m_46859_(pos) || !state2.m_60713_((Block)GCYRBlocks.LAUNCH_PAD.get()) && state.m_60713_((Block)GCYRBlocks.LAUNCH_PAD.get()))) {
                this.unBuild();
                return true;
            }
        }
        return false;
    }

    protected void checkOnBlocks() {
        AABB aabb = this.m_20191_();
        BlockPos blockPos1 = new BlockPos((int)aabb.f_82288_, (int)(aabb.f_82289_ - 0.2), (int)aabb.f_82290_);
        BlockPos blockPos2 = new BlockPos((int)aabb.f_82291_, (int)aabb.f_82289_, (int)aabb.f_82293_);
        if (this.m_9236_().m_46832_(blockPos1, blockPos2)) {
            for (int i = blockPos1.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos1.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos1.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        BlockPos pos = new BlockPos(i, j, k);
                        BlockState state = this.m_9236_().m_8055_(pos);
                        if (!this.doesDrop(state, pos)) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean consumeFuel() {
        int recipeDuration = this.getRecipeDuration();
        int destinationRocketTier = 1;
        if (this.getDestination() != null) {
            destinationRocketTier = this.getDestination().rocketTier();
        }
        double drain = (double)(this.getThrusterCount() + destinationRocketTier) / ((double)recipeDuration / 20.0 + 1.0) * 2.0;
        long ldrain = (long)drain;
        if (this.isRemote()) {
            Long fuelAmount = (Long)this.f_19804_.m_135370_(FUEL_AMOUNT);
            return fuelAmount - ldrain > 0L;
        }
        if (!this.fuelTank.drain(ldrain, true).isEmpty()) {
            return !this.fuelTank.drain(ldrain, false).isEmpty();
        }
        return false;
    }

    private void goToDestination() {
        ResourceKey<Level> destinationDim;
        Object object;
        if (this.m_20186_() < 600.0) {
            return;
        }
        this.speed = 0.0;
        if (this.isRemote()) {
            return;
        }
        ItemStack configStack = this.configSlot.getStackInSlot(0);
        ItemStack satelliteStack = this.satelliteSlot.getStackInSlot(0);
        if (this.getDestination() == null && GCYRItems.ID_CHIP.isIn(configStack)) {
            this.setDestination(PlanetIdChipBehaviour.getPlanetFromStack(configStack));
        } else if (GCYRItems.KEYCARD.isIn(configStack) && KeyCardBehaviour.getSavedStation(configStack) != null) {
            this.destinationIsSpaceStation = true;
            if (!satelliteStack.m_150930_((Item)GCYRItems.SPACE_STATION_PACKAGE.get()) && GCYRCapabilityHelper.getSpaceStations(this.m_20194_().m_129880_(this.getDestination().orbitWorld())).getStation(KeyCardBehaviour.getSavedStation(configStack)) == null) {
                this.setDestination(null);
                this.destinationIsSpaceStation = false;
                this.f_19804_.m_135381_(ROCKET_STARTED, (Object)false);
                this.m_20334_(0.0, -0.5, 0.0);
                return;
            }
        } else if (satelliteStack.m_204117_(GCYRTags.SATELLITES) && (object = satelliteStack.m_41720_()) instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)object;
            for (Object component : componentItem.getComponents()) {
                if (!(component instanceof SatelliteItemBehaviour)) continue;
                SatelliteItemBehaviour satelliteItem = (SatelliteItemBehaviour)component;
                this.returnToStart = true;
                this.satelliteToLaunch = satelliteItem.type;
            }
        }
        ResourceKey<Level> resourceKey = destinationDim = this.destinationIsSpaceStation ? this.getDestination().orbitWorld() : this.getDestination().level();
        if (this.fuelTank.drain(this.computeRequiredFuelAmountForDestination(this.getDestination()) / 3L, true).isEmpty()) {
            ArrayList<Planet> validPlanets = new ArrayList<Planet>();
            for (Planet planet : PlanetData.planets().values()) {
                if (!planet.solarSystem().equals((Object)this.getDestination().solarSystem())) continue;
                validPlanets.add(planet);
            }
            Planet destPlanet = (Planet)validPlanets.get(GTValues.RNG.m_188503_(validPlanets.size()));
            destinationDim = destPlanet.level();
        }
        ServerLevel destinationLevel = this.m_20194_().m_129880_(destinationDim);
        BlockPos destinationPos = null;
        if (this.lastPos != null && this.lastPos.m_122640_().equals(destinationDim)) {
            destinationPos = this.lastPos.m_122646_();
        }
        List passengers = this.m_20197_();
        RocketEntity newRocket = this.returnToStart ? this : PlatformUtils.changeDimension(this, destinationLevel);
        if (newRocket == null) {
            this.setDestination(null);
            this.destinationIsSpaceStation = false;
            this.f_19804_.m_135381_(ROCKET_STARTED, (Object)false);
            this.m_20334_(0.0, -0.5, 0.0);
            return;
        }
        HashSet newPassengers = new HashSet();
        passengers.forEach(passenger -> {
            Entity newPassenger = PlatformUtils.changeDimension(passenger, destinationLevel);
            if (newPassenger != null) {
                newPassenger.m_20329_(newRocket);
                newPassengers.add(newPassenger);
            } else {
                passenger.m_20329_(newRocket);
                newPassengers.add(passenger);
            }
        });
        Vec3 pos = this.m_20182_();
        if (this.destinationIsSpaceStation) {
            Integer stationId;
            ISpaceStationHolder stations = GCYRCapabilityHelper.getSpaceStations(destinationLevel);
            boolean didChange = false;
            if (GCYRItems.KEYCARD.isIn(configStack)) {
                stationId = KeyCardBehaviour.getSavedStation(configStack);
                if (stations.getStation(stationId) == null) {
                    allocated = stations.allocateStation(this.getDestination());
                    stations.addStation((Integer)allocated.getFirst(), (SpaceStation)allocated.getSecond());
                    stationId = (Integer)allocated.getFirst();
                    KeyCardBehaviour.setSavedStation(configStack, stationId, KeyCardBehaviour.getSavedPlanet(configStack));
                    didChange = true;
                }
            } else if (GCYRItems.ID_CHIP.isIn(configStack)) {
                stationId = PlanetIdChipBehaviour.getSpaceStationId(configStack);
                if (stations.getStation(stationId) == null) {
                    allocated = stations.allocateStation(this.getDestination());
                    stations.addStation((Integer)allocated.getFirst(), (SpaceStation)allocated.getSecond());
                    stationId = (Integer)allocated.getFirst();
                    PlanetIdChipBehaviour.setSpaceStation(configStack, stationId);
                    didChange = true;
                }
            } else {
                stationId = null;
            }
            if (didChange) {
                newPassengers.forEach(entity -> {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_213846_((Component)Component.m_237115_((String)"message.gcyr.notice_id_changed"));
                    }
                });
            }
            BlockPos stationPos = stations.getStationWorldPos(stationId);
            if (destinationPos == null) {
                destinationPos = new BlockPos(stationPos.m_123341_(), (int)pos.f_82480_, stationPos.m_123343_());
            }
            if (newRocket instanceof RocketEntity) {
                RocketEntity rocketEntity = newRocket;
                if (GCYRItems.SPACE_STATION_PACKAGE.isIn(this.satelliteSlot.getStackInSlot(0))) {
                    ItemStack stack = this.satelliteSlot.getStackInSlot(0);
                    rocketEntity.buildSpaceStation(stack, new BlockPos(destinationPos.m_123341_(), 64, destinationPos.m_123343_()));
                }
            }
        } else {
            double scale = DimensionType.m_63908_((DimensionType)this.m_9236_().m_6042_(), (DimensionType)destinationLevel.m_6042_());
            if (destinationPos == null) {
                destinationPos = BlockPos.m_274446_((Position)pos.m_82542_(scale, 1.0, scale));
            }
        }
        newRocket.m_6034_(destinationPos.m_123341_(), destinationPos.m_123342_(), destinationPos.m_123343_());
        Vec3 delta = this.m_20184_();
        newRocket.m_20334_(delta.f_82479_, -0.5, delta.f_82481_);
        if (newRocket instanceof RocketEntity) {
            RocketEntity rocketEntity = newRocket;
            rocketEntity.lastPos = this.destinationIsSpaceStation ? GlobalPos.m_122643_(destinationDim, (BlockPos)this.m_20097_()) : null;
            rocketEntity.setDestination(null);
            rocketEntity.destinationIsSpaceStation = false;
            rocketEntity.f_19804_.m_135381_(ROCKET_STARTED, (Object)false);
            rocketEntity.f_19804_.m_135381_(START_TIMER, (Object)0);
        }
    }

    public void unBuild() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.configSlot.getStackInSlot(0).m_41619_()) {
            this.m_19983_(this.configSlot.getStackInSlot(0));
        }
        if (!this.satelliteSlot.getStackInSlot(0).m_41619_()) {
            this.m_19983_(this.satelliteSlot.getStackInSlot(0));
        }
        BlockPos origin = this.m_20183_();
        for (PosWithState state : this.getBlocks()) {
            BlockPos offset = origin.m_121955_((Vec3i)state.pos());
            BlockHitResult result = new BlockHitResult(offset.m_252807_(), Direction.DOWN, offset, false);
            if (!this.m_9236_().m_8055_(offset).m_60795_() && !this.m_9236_().m_8055_(offset).m_60629_(new BlockPlaceContext(this.m_9236_(), null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, result))) {
                this.m_19998_((ItemLike)state.state().m_60734_().m_5456_());
                continue;
            }
            this.m_9236_().m_7731_(offset, state.state(), 3);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void buildSpaceStation(ItemStack stack, BlockPos origin) {
        if (!GCYRItems.SPACE_STATION_PACKAGE.isIn(stack)) {
            return;
        }
        Set<PosWithState> blocks = StationContainerBehaviour.getStationBlocks(stack);
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        boolean start = true;
        BlockPos original = origin;
        for (PosWithState state : blocks) {
            BlockPos pos = state.pos();
            if (start) {
                origin = original.m_121955_((Vec3i)pos);
            }
            start = false;
            if (origin.compareTo((Vec3i)pos.m_121955_((Vec3i)original)) <= 0) continue;
            origin = new BlockPos(Math.min(original.m_123341_() - pos.m_123341_(), origin.m_123341_()), Math.min(original.m_123342_() - pos.m_123342_(), origin.m_123342_()), Math.min(original.m_123343_() - pos.m_123343_(), origin.m_123343_()));
        }
        for (PosWithState state : blocks) {
            BlockPos offset = origin.m_121955_((Vec3i)state.pos());
            BlockState originalState = this.m_9236_().m_8055_(offset);
            if (!originalState.m_60795_() && !originalState.m_247087_()) {
                this.m_19998_((ItemLike)state.state().m_60734_().m_5456_());
                continue;
            }
            this.m_9236_().m_7731_(offset, state.state(), 3);
        }
    }

    public void placeSatellite() {
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public long getFuelCapacity() {
        return (Long)this.f_19804_.m_135370_(FUEL_CAPACITY);
    }

    public void setFuelCapacity(long fuelCapacity) {
        this.f_19804_.m_135381_(FUEL_CAPACITY, (Object)fuelCapacity);
        this.reinitializeFluidStorage();
    }

    public int getThrusterCount() {
        return (Integer)this.f_19804_.m_135370_(THRUSTER_COUNT);
    }

    public void setThrusterCount(int count) {
        this.f_19804_.m_135381_(THRUSTER_COUNT, (Object)count);
    }

    public int getRecipeDuration() {
        return (Integer)this.f_19804_.m_135370_(RECIPE_DURATION);
    }

    public void setRecipeDuration(int duration) {
        this.f_19804_.m_135381_(RECIPE_DURATION, (Object)duration);
    }

    public int getWeight() {
        return (Integer)this.f_19804_.m_135370_(WEIGHT);
    }

    public void setWeight(int weight) {
        this.f_19804_.m_135381_(WEIGHT, (Object)weight);
    }

    public int getStartTimer() {
        return (Integer)this.f_19804_.m_135370_(START_TIMER);
    }

    public void setStartTimer(int timer) {
        this.f_19804_.m_135381_(START_TIMER, (Object)timer);
    }

    public void addBlock(BlockPos pos, BlockState state) {
        this.addBlock(new PosWithState(pos, state));
    }

    public void setDestination(@Nullable Planet destination) {
        this.f_19804_.m_135381_(DESTINATION, Optional.ofNullable(destination));
    }

    @Nullable
    public Planet getDestination() {
        return ((Optional)this.f_19804_.m_135370_(DESTINATION)).orElse(null);
    }

    public void addBlock(PosWithState state) {
        List<PosWithState> blocks = this.getBlocks();
        if (blocks.stream().anyMatch(pws -> pws.pos().equals((Object)state.pos()))) {
            return;
        }
        blocks.add(state);
        this.setBlocks(blocks);
        BlockPos pos = state.pos();
        BlockPos size = (BlockPos)this.f_19804_.m_135370_(SIZE);
        this.f_19804_.m_135381_(SIZE, (Object)new BlockPos(Math.max(size.m_123341_(), pos.m_123341_()), Math.max(size.m_123342_(), pos.m_123342_()), Math.max(size.m_123343_(), pos.m_123343_())));
        Block block = state.state().m_60734_();
        float destroyTime = block.m_155943_();
        if (destroyTime > 0.0f) {
            this.setWeight(this.getWeight() + (int)(destroyTime / 2.5f));
        }
        if (block instanceof IRocketPart) {
            IRocketPart part = (IRocketPart)block;
            this.partCounts.put((Object)part, this.partCounts.getOrDefault((Object)part, 0) + 1);
        }
        if (block instanceof RocketMotorBlock) {
            RocketMotorBlock rocketMotorBlock = (RocketMotorBlock)block;
            this.setThrusterCount(this.getThrusterCount() + rocketMotorBlock.getMotorType().getMotorCount());
            this.thrusterPositions.add(pos);
            this.motorTiersTotal += rocketMotorBlock.getTier();
            this.motorTier = this.motorTiersTotal / this.partCounts.object2IntEntrySet().stream().filter(p -> p.getKey() instanceof RocketMotorBlock).map(Map.Entry::getValue).reduce(0, Integer::sum);
        } else if (block instanceof FuelTankBlock) {
            FuelTankBlock fuelTankBlock = (FuelTankBlock)block;
            this.setFuelCapacity(this.getFuelCapacity() + fuelTankBlock.getTankProperties().getFuelStorage());
            this.fuelTankTiersTotal += fuelTankBlock.getTier();
            this.fuelTankTier = this.fuelTankTiersTotal / this.partCounts.object2IntEntrySet().stream().filter(p -> p.getKey() instanceof FuelTankBlock).map(Map.Entry::getValue).reduce(0, Integer::sum);
        } else if (state.state().m_60713_((Block)GCYRBlocks.SEAT.get())) {
            this.addSeatPos(pos);
        }
        this.partsTier = (this.motorTier + this.fuelTankTier) / 2;
        this.m_20011_(this.m_142242_());
    }

    public List<PosWithState> getBlocks() {
        return (List)this.f_19804_.m_135370_(POSITIONED_STATES);
    }

    public void setBlocks(List<PosWithState> blocks) {
        this.f_19804_.m_276349_(POSITIONED_STATES, blocks, true);
    }

    public void addSeatPos(BlockPos pos) {
        List seats = (List)this.f_19804_.m_135370_(SEAT_POSITIONS);
        seats.add(pos);
        this.f_19804_.m_276349_(SEAT_POSITIONS, (Object)seats, true);
    }

    public List<BlockPos> getSeatPositions() {
        return (List)this.f_19804_.m_135370_(SEAT_POSITIONS);
    }

    public String getDisplayThrust() {
        double thrust = this.getRocketSpeed();
        ChatFormatting style = thrust < 0.01 ? ChatFormatting.RED : (thrust < 1.01 ? ChatFormatting.GOLD : ChatFormatting.GREEN);
        MutableComponent thrustComponent = Component.m_237113_((String)String.format("%.1f", thrust)).m_130940_(style);
        return Component.m_237110_((String)"menu.gcyr.rocket.thrust", (Object[])new Object[]{thrustComponent}).getString();
    }

    public double getRocketSpeed() {
        return (double)this.getThrusterCount() * 4.0 - (double)(this.getWeight() + 1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROCKET_STARTED, (Object)false);
        this.f_19804_.m_135372_(FUEL_CAPACITY, (Object)0L);
        this.f_19804_.m_135372_(THRUSTER_COUNT, (Object)0);
        this.f_19804_.m_135372_(WEIGHT, (Object)0);
        this.f_19804_.m_135372_(RECIPE_DURATION, (Object)0);
        this.f_19804_.m_135372_(START_TIMER, (Object)0);
        this.f_19804_.m_135372_(FUEL_AMOUNT, (Object)0L);
        this.f_19804_.m_135372_(POSITIONED_STATES, new ArrayList());
        this.f_19804_.m_135372_(SEAT_POSITIONS, new ArrayList());
        this.f_19804_.m_135372_(SIZE, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DESTINATION, Optional.empty());
    }

    protected void m_7378_(CompoundTag compound) {
        this.getBlocks().clear();
        ListTag blocks = compound.m_128437_("blocks", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            this.addBlock(PosWithState.readFromTag(blocks.m_128728_(i)));
        }
        this.setFuelCapacity(compound.m_128454_("fuelCapacity"));
        this.fuelTank.setFluid(FluidStack.loadFromTag((CompoundTag)compound.m_128469_("fuel")));
        this.configSlot.deserializeNBT(compound.m_128469_("config"));
        this.returnToStart = compound.m_128471_("returnToStart");
        if (compound.m_128441_("satelliteToLaunch")) {
            this.satelliteToLaunch = (SatelliteType)GCYRRegistries.SATELLITES.get((Object)new ResourceLocation(compound.m_128461_("satelliteToLaunch")));
        }
        this.setThrusterCount(compound.m_128451_("thrusterCount"));
        this.setStartTimer(compound.m_128451_("startTimer"));
        this.f_19804_.m_135381_(ROCKET_STARTED, (Object)compound.m_128471_("isStarted"));
        this.setWeight(compound.m_128451_("weight"));
        this.setDestination(compound.m_128425_("destination", 8) ? PlanetData.getPlanet(new ResourceLocation(compound.m_128461_("destination"))) : null);
        if (compound.m_128441_("selectedFuelRecipe")) {
            this.selectedFuelRecipe = this.m_20194_().m_129894_().m_44043_(new ResourceLocation(compound.m_128461_("selectedFuelRecipe"))).orElse(null);
        }
        if (compound.m_128441_("recipeDuration")) {
            this.setRecipeDuration(compound.m_128451_("recipeDuration"));
        }
        if (compound.m_128441_("lastPos")) {
            CompoundTag tag = compound.m_128469_("lastPos");
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
            ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("level")));
            this.lastPos = GlobalPos.m_122643_((ResourceKey)level, (BlockPos)pos);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        List<PosWithState> blocks = this.getBlocks();
        ListTag blockTag = new ListTag();
        compound.m_128365_("blocks", (Tag)blockTag);
        for (PosWithState state : blocks) {
            blockTag.add((Object)state.writeToTag());
        }
        compound.m_128356_("fuelCapacity", this.getFuelCapacity());
        CompoundTag fuel = new CompoundTag();
        this.fuelTank.getFluid().saveToTag(fuel);
        compound.m_128365_("fuel", (Tag)fuel);
        compound.m_128365_("config", (Tag)this.configSlot.serializeNBT());
        compound.m_128379_("returnToStart", this.returnToStart);
        if (this.satelliteToLaunch != null) {
            compound.m_128359_("satelliteToLaunch", ((ResourceLocation)GCYRRegistries.SATELLITES.getKey(this.satelliteToLaunch)).toString());
        }
        compound.m_128405_("thrusterCount", this.getThrusterCount());
        compound.m_128405_("startTimer", this.getStartTimer());
        compound.m_128379_("isStarted", ((Boolean)this.f_19804_.m_135370_(ROCKET_STARTED)).booleanValue());
        compound.m_128405_("weight", this.getWeight());
        if (this.getDestination() != null) {
            compound.m_128359_("destination", PlanetData.getPlanetId(this.getDestination()).toString());
        }
        if (this.selectedFuelRecipe != null) {
            compound.m_128359_("selectedFuelRecipe", this.selectedFuelRecipe.id.toString());
        }
        if (this.lastPos != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastPos.m_122646_()));
            tag.m_128359_("level", this.lastPos.m_122640_().m_135782_().toString());
            compound.m_128365_("lastPos", (Tag)tag);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (POSITIONED_STATES.equals(key) || SIZE.equals(key)) {
            this.m_20011_(this.m_142242_());
            this.hasRequestedBlockSync.set(false);
        }
        super.m_7350_(key);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        GCYREntityDataSerializers.POSITIONED_BLOCK_STATE_LIST.m_6856_(buf, this.getBlocks());
        GCYREntityDataSerializers.BLOCK_POS_LIST.m_6856_(buf, this.getSeatPositions());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.setBlocks((List)GCYREntityDataSerializers.POSITIONED_BLOCK_STATE_LIST.m_6709_(buf));
        this.f_19804_.m_135381_(SEAT_POSITIONS, (Object)((List)GCYREntityDataSerializers.BLOCK_POS_LIST.m_6709_(buf)));
    }

    public static void setEntityRotation(Entity vehicle, float rotation) {
        vehicle.m_146922_(vehicle.m_146908_() + rotation);
        vehicle.m_5618_(vehicle.m_146908_());
        vehicle.f_19859_ = vehicle.m_146908_();
    }

    public static void sendVehicleHasNoFuelMessage(Player player, long fuel, long required) {
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)"message.gcyr.no_fuel", (Object[])new Object[]{fuel, required}), false);
        }
    }

    public static void sendVehicleHasInvalidIdMessage(Player player) {
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"message.gcyr.invalid_id"), false);
        }
    }

    public static void sendVehicleNotGoodEnoughMessage(Player player, int planetTier) {
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)"message.gcyr.rocket_not_good_enough", (Object[])new Object[]{planetTier}), false);
        }
    }

    public boolean isInvalid() {
        return this.m_213877_();
    }

    public boolean isRemote() {
        return this.m_9236_().f_46443_;
    }

    public void markAsDirty() {
    }

    public ThreadLocal<Boolean> getHasRequestedBlockSync() {
        return this.hasRequestedBlockSync;
    }
}

