/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.common.data;

import argent_matter.gcyr.GCYR;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class GCYRBiomes {
    public static final ResourceKey<Biome> SPACE = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("space"));
    public static final ResourceKey<Biome> MOON = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("moon"));
    public static final ResourceKey<Biome> VENUS_ERODED_PLAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("venus_eroded_plains"));
    public static final ResourceKey<Biome> MARTIAN_CANYON_CREEK = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("martian_canyon_creek"));
    public static final ResourceKey<Biome> MARTIAN_POLAR_CAPS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("martian_polar_caps"));
    public static final ResourceKey<Biome> MARTIAN_WASTELANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("martian_wastelands"));
    public static final ResourceKey<Biome> MERCURY_DELTAS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("mercury_deltas"));
    public static final ResourceKey<Biome> VENUS_BARREN_PLAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)GCYR.id("venus_barren_plains"));

    public static void bootstrap(BootstapContext<Biome> ctx) {
        ctx.m_255272_(SPACE, (Object)GCYRBiomes.space((HolderGetter<PlacedFeature>)ctx.m_255420_(Registries.f_256988_), ctx.m_255420_(Registries.f_257003_)));
    }

    public static Biome space(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        return GCYRBiomes.biome(0.0f, 0.5f, 0.5f, new MobSpawnSettings.Builder(), builder, null);
    }

    private static Biome biome(float downfall, float temp, float rainfall, MobSpawnSettings.Builder spawn, BiomeGenerationSettings.Builder gen, @Nullable Music music) {
        return GCYRBiomes.biome(downfall, temp, rainfall, 4159204, 329011, spawn, gen, music);
    }

    private static Biome biome(float downfall, float temp, float rainfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder mobSpawning, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47611_(downfall).m_47609_(temp).m_47611_(rainfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(GCYRBiomes.calculateSkyColor(temp)).m_48021_(music).m_48018_()).m_47605_(mobSpawning.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    protected static int calculateSkyColor(float temperature) {
        float temp = temperature / 3.0f;
        temp = Mth.m_14036_((float)temp, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - temp * 0.05f), (float)(0.5f + temp * 0.1f), (float)1.0f);
    }
}

