/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.syncdata.entity;

import argent_matter.gcyr.api.syncdata.entity.IManagedEntity;
import com.google.common.base.Strings;
import com.lowdragmc.lowdraglib.syncdata.accessor.IManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.utils.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface IAutoPersistEntity
extends IManagedEntity {
    default public void saveManagedPersistentData(CompoundTag tag) {
        IRef[] persistedFields;
        IRef[] copy = persistedFields = this.getRootStorage().getPersistedFields();
        int length = persistedFields.length;
        for (int i = 0; i < length; ++i) {
            Tag nbt;
            IRef persistedField = copy[i];
            ManagedKey fieldKey = persistedField.getKey();
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = fieldKey.readPersistedField(persistedField)) == null) continue;
            TagUtils.setTagExtended((CompoundTag)tag, (String)key, (Tag)nbt);
        }
        this.saveCustomPersistedData(tag);
    }

    default public void loadManagedPersistentData(CompoundTag tag) {
        IRef[] refs = this.getRootStorage().getPersistedFields();
        IManagedAccessor.writePersistedFields((CompoundTag)tag, (IRef[])refs);
        this.loadCustomPersistedData(tag);
    }

    default public void saveCustomPersistedData(CompoundTag tag) {
    }

    default public void loadCustomPersistedData(CompoundTag tag) {
    }
}

