/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.space.planet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public record PlanetSkyRenderer(ResourceKey<Level> dimension, StarsRenderer starsRenderer, DimensionEffects effects, CloudEffects cloudEffects, WeatherEffects weatherEffects, int horizonAngle, List<SkyObject> skyObjects) {
    public static final Codec<PlanetSkyRenderer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("world").forGetter(PlanetSkyRenderer::dimension), (App)StarsRenderer.CODEC.fieldOf("stars").forGetter(PlanetSkyRenderer::starsRenderer), (App)DimensionEffects.CODEC.fieldOf("dimension_effects").forGetter(PlanetSkyRenderer::effects), (App)CloudEffects.CODEC.fieldOf("cloud_effects").forGetter(PlanetSkyRenderer::cloudEffects), (App)WeatherEffects.CODEC.fieldOf("weather_effects").forGetter(PlanetSkyRenderer::weatherEffects), (App)Codec.INT.fieldOf("horizon_angle").forGetter(PlanetSkyRenderer::horizonAngle), (App)SkyObject.CODEC.listOf().fieldOf("sky_objects").forGetter(PlanetSkyRenderer::skyObjects)).apply((Applicative)instance, PlanetSkyRenderer::new));

    public record StarsRenderer(int fancyStars, int fastStars, boolean colouredStars, boolean daylightVisible) {
        public static final Codec<StarsRenderer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fancy_count").forGetter(StarsRenderer::fancyStars), (App)Codec.INT.fieldOf("fast_count").forGetter(StarsRenderer::fastStars), (App)Codec.BOOL.fieldOf("colored_stars").forGetter(StarsRenderer::colouredStars), (App)Codec.BOOL.fieldOf("daylight_visible").forGetter(StarsRenderer::daylightVisible)).apply((Applicative)instance, StarsRenderer::new));
    }

    public record DimensionEffects(DimensionEffectType type, int colour) {
        public static final Codec<DimensionEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionEffectType.CODEC.fieldOf("type").forGetter(DimensionEffects::type), (App)Codec.INT.fieldOf("color").orElse((Object)-1).forGetter(DimensionEffects::colour)).apply((Applicative)instance, DimensionEffects::new));
    }

    public static enum CloudEffects implements StringRepresentable
    {
        NONE,
        VANILLA;

        public static final Codec<CloudEffects> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(CloudEffects::values);
        }
    }

    public static enum WeatherEffects implements StringRepresentable
    {
        NONE,
        VANILLA;

        public static final Codec<WeatherEffects> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(WeatherEffects::values);
        }
    }

    public record SkyObject(ResourceLocation texture, boolean blending, RenderType renderType, float scale, int colour, Vector3f rotation) {
        public static final Codec<SkyObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(SkyObject::texture), (App)Codec.BOOL.fieldOf("blending").forGetter(SkyObject::blending), (App)RenderType.CODEC.fieldOf("render_type").forGetter(SkyObject::renderType), (App)Codec.FLOAT.fieldOf("scale").forGetter(SkyObject::scale), (App)Codec.INT.fieldOf("color").orElse((Object)-1).forGetter(SkyObject::colour), (App)ExtraCodecs.f_252432_.fieldOf("rotation").forGetter(SkyObject::rotation)).apply((Applicative)instance, SkyObject::new));
    }

    public static enum DimensionEffectType implements StringRepresentable
    {
        SIMPLE,
        NONE,
        FOGGY_REVERSED,
        FOGGY,
        COLORED_HORIZON;

        public static final Codec<DimensionEffectType> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isFoggy() {
            return this == FOGGY || this == FOGGY_REVERSED;
        }

        static {
            CODEC = StringRepresentable.m_216439_(DimensionEffectType::values);
        }
    }

    public static enum RenderType implements StringRepresentable
    {
        STATIC,
        DYNAMIC,
        SCALING,
        DEBUG;

        public static final Codec<RenderType> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(RenderType::values);
        }
    }
}

