/*
 * Decompiled with CFR 0.152.
 */
package argent_matter.gcyr.api.capability;

import argent_matter.gcyr.api.space.satellite.Satellite;
import argent_matter.gcyr.api.space.satellite.SatelliteType;
import argent_matter.gcyr.util.Vec2i;
import java.util.List;
import javax.annotation.Nullable;

public interface ISatelliteHolder {
    public List<Satellite> getSatellites();

    public void tickSatellites();

    default public <T extends Satellite> List<T> getSatellitesOfType(SatelliteType<T> type) {
        return this.getSatellites().stream().filter(obj -> obj.getType() == type).toList();
    }

    default public <T extends Satellite> int getSatelliteCount(SatelliteType<T> type) {
        return this.getSatellites().stream().filter(obj -> obj.getType() == type).mapToInt(obj -> 1).sum();
    }

    @Nullable
    public Satellite getClosestSatellite(Vec2i var1);

    @Nullable
    public List<Satellite> getSatellitesNearPos(Vec2i var1, int var2);

    public void addSatellite(@Nullable Satellite var1);

    public void destroySatellite(Satellite var1);
}

