/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.client.item.FluidDrawerISTER;
import com.buuz135.functionalstorage.inventory.item.DrawerCapabilityProvider;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDrawerBlock
extends RotatableBlock<FluidDrawerTile>
implements Drawer {
    private final FunctionalStorage.DrawerType type;

    public FluidDrawerBlock(FunctionalStorage.DrawerType type, BlockBehaviour.Properties properties) {
        super("fluid_" + type.getSlots(), properties, FluidDrawerTile.class);
        this.type = type;
        this.setItemGroup(FunctionalStorage.TAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, FunctionalStorage.DrawerType type) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        DrawerBlock.CACHED_SHAPES.get((Object)type).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.m_83144_();
        boxes.add(total);
        return boxes;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{DrawerBlock.LOCKED});
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public BlockEntityType.BlockEntitySupplier<FluidDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> {
            BlockEntityType entityType = (BlockEntityType)((RegistryObject)FunctionalStorage.FLUID_DRAWER_1.getRight()).get();
            if (this.type == FunctionalStorage.DrawerType.X_2) {
                entityType = (BlockEntityType)((RegistryObject)FunctionalStorage.FLUID_DRAWER_2.getRight()).get();
            }
            if (this.type == FunctionalStorage.DrawerType.X_4) {
                entityType = (BlockEntityType)((RegistryObject)FunctionalStorage.FLUID_DRAWER_4.getRight()).get();
            }
            return new FluidDrawerTile((BasicTileBlock<FluidDrawerTile>)this, (BlockEntityType<FluidDrawerTile>)entityType, blockPos, state, this.type);
        };
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return FluidDrawerBlock.getShapes(state, source, pos, this.type);
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, FluidDrawerTile.class).map(drawerTile -> drawerTile.onSlotActivated(player, hand, ray.m_82434_(), ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_, this.getHit(state, worldIn, pos, player))).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, FluidDrawerTile.class).ifPresent(drawerTile -> drawerTile.onClicked(player, this.getHit(state, worldIn, pos, player)));
    }

    @Override
    public int getHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null) {
            if (hit.equals(Shapes.m_83144_())) {
                return -1;
            }
            ArrayList shapes = new ArrayList();
            shapes.addAll(DrawerBlock.CACHED_SHAPES.get((Object)this.type).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))));
            for (int i = 0; i < shapes.size(); ++i) {
                if (!Shapes.m_83157_((VoxelShape)((VoxelShape)shapes.get(i)), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return i;
            }
        }
        return -1;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public List<ItemStack> m_49635_(BlockState p_60537_, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.m_122779_();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity drawerTile = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (drawerTile instanceof FluidDrawerTile) {
            FluidDrawerTile tile = (FluidDrawerTile)drawerTile;
            if (!tile.isEverythingEmpty()) {
                stack.m_41784_().m_128365_("Tile", (Tag)drawerTile.m_187482_());
            }
            if (tile.isLocked()) {
                stack.m_41784_().m_128379_("Locked", tile.isLocked());
            }
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.m_122779_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack stack) {
        BlockEntity entity;
        super.m_6402_(level, pos, p_49849_, p_49850_, stack);
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("Tile") && (entity = level.m_7702_(pos)) instanceof ControllableDrawerTile) {
                ControllableDrawerTile tile = (ControllableDrawerTile)entity;
                entity.m_142466_(stack.m_41783_().m_128469_("Tile"));
                tile.markForUpdate();
            }
            if (stack.m_41783_().m_128441_("Locked")) {
                level.m_7731_(pos, (BlockState)p_49849_.m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        entity = level.m_7702_(pos);
        ItemStack offhand = p_49850_.m_21206_();
        if (offhand.m_150930_((Item)FunctionalStorage.CONFIGURATION_TOOL.get())) {
            ConfigurationToolItem.ConfigurationAction action = ConfigurationToolItem.getAction(offhand);
            if (entity instanceof ControllableDrawerTile) {
                ControllableDrawerTile tile = (ControllableDrawerTile)entity;
                if (action == ConfigurationToolItem.ConfigurationAction.LOCKING) {
                    tile.setLocked(true);
                } else if (action.getMax() == 1) {
                    tile.getDrawerOptions().setActive(action, false);
                } else {
                    tile.getDrawerOptions().setAdvancedValue(action, 1);
                }
            }
        }
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        if (this.type == FunctionalStorage.DrawerType.X_1) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("PPP").m_126130_("PCP").m_126130_("PPP").m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_176498_(consumer);
        }
        if (this.type == FunctionalStorage.DrawerType.X_2) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).m_126130_("PCP").m_126130_("PPP").m_126130_("PCP").m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_176498_(consumer);
        }
        if (this.type == FunctionalStorage.DrawerType.X_4) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).m_126130_("CPC").m_126130_("PPP").m_126130_("CPC").m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_176498_(consumer);
        }
    }

    public FunctionalStorage.DrawerType getType() {
        return this.type;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, FluidDrawerTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), StorageControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter p_49817_, List<Component> tooltip, TooltipFlag p_49819_) {
        super.m_5871_(itemStack, p_49817_, tooltip, p_49819_);
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("Tile")) {
            CompoundTag tileTag = itemStack.m_41783_().m_128469_("Tile").m_128469_("fluidHandler");
            tooltip.add((Component)Component.m_237115_((String)"drawer.block.contents").m_130940_(ChatFormatting.GRAY));
            for (int i = 0; i < this.type.getSlots(); ++i) {
                FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)tileTag.m_128469_("" + i));
                if (stack.isEmpty()) continue;
                tooltip.add((Component)Component.m_237113_((String)(" - " + ChatFormatting.YELLOW + NumberUtils.getFormatedFluidBigNumber(stack.getAmount()) + ChatFormatting.WHITE + " of ")).m_7220_((Component)stack.getDisplayName().m_6881_().m_130940_(ChatFormatting.GOLD)));
            }
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return true;
    }

    public int m_6378_(BlockState p_60483_, BlockGetter blockGetter, BlockPos blockPos, Direction p_60486_) {
        FluidDrawerTile tile = TileUtil.getTileEntity((BlockGetter)blockGetter, (BlockPos)blockPos, FluidDrawerTile.class).orElse(null);
        if (tile != null) {
            for (int i = 0; i < tile.getUtilityUpgrades().getSlots(); ++i) {
                int redstoneSlot;
                ItemStack stack = tile.getUtilityUpgrades().getStackInSlot(i);
                if (!stack.m_41720_().equals(FunctionalStorage.REDSTONE_UPGRADE.get()) || (redstoneSlot = stack.m_41784_().m_128451_("Slot")) >= tile.getFluidHandler().getTanks()) continue;
                return tile.getFluidHandler().getFluidInTank(redstoneSlot).getAmount() * 15 / tile.getFluidHandler().getTankCapacity(redstoneSlot);
            }
        }
        return 0;
    }

    public static class FluidDrawerItem
    extends BlockItem {
        private FluidDrawerBlock drawerBlock;

        public FluidDrawerItem(FluidDrawerBlock p_40565_, Item.Properties p_40566_, TitaniumTab tab) {
            super((Block)p_40565_, p_40566_);
            this.drawerBlock = p_40565_;
            tab.getTabList().add(this);
        }

        public Optional<TooltipComponent> m_142422_(ItemStack stack) {
            return super.m_142422_(stack);
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new DrawerCapabilityProvider(stack, this.drawerBlock.getType());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return switch (drawerBlock.getType()) {
                        case FunctionalStorage.DrawerType.X_2 -> FluidDrawerISTER.SLOT_2;
                        case FunctionalStorage.DrawerType.X_4 -> FluidDrawerISTER.SLOT_4;
                        default -> FluidDrawerISTER.SLOT_1;
                    };
                }
            });
        }
    }
}

