/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.terminal;

import appeng.helpers.IPatternTerminalLogicHost;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.parts.encoding.PatternEncodingLogic;
import gripe._90.fulleng.block.entity.terminal.StorageTerminalBlockEntity;
import gripe._90.fulleng.definition.FullEngBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PatternEncodingTerminalBlockEntity
extends StorageTerminalBlockEntity
implements IPatternTerminalMenuHost {
    private final IPatternTerminalLogicHost hostProxy = new LogicHostProxy();
    private final PatternEncodingLogic logic = new PatternEncodingLogic(this.hostProxy);

    public PatternEncodingTerminalBlockEntity(BlockPos pos, BlockState blockState) {
        super(FullEngBlockEntities.PATTERN_ENCODING_TERMINAL, pos, blockState);
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        this.logic.getBlankPatternInv().forEach(drops::add);
        this.logic.getEncodedPatternInv().forEach(drops::add);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.logic.readFromNBT(data);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.logic.writeToNBT(data);
    }

    @Override
    public MenuType<?> getMenuType() {
        return PatternEncodingTermMenu.TYPE;
    }

    public PatternEncodingLogic getLogic() {
        return this.logic;
    }

    private class LogicHostProxy
    implements IPatternTerminalLogicHost {
        private LogicHostProxy() {
        }

        public PatternEncodingLogic getLogic() {
            return PatternEncodingTerminalBlockEntity.this.logic;
        }

        public Level getLevel() {
            return PatternEncodingTerminalBlockEntity.this.f_58857_;
        }

        public void markForSave() {
            PatternEncodingTerminalBlockEntity.this.saveChanges();
            PatternEncodingTerminalBlockEntity.this.markForUpdate();
        }
    }
}

