/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates.recipe;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import ky.someone.mods.framingtemplates.item.FramingTemplateItem;
import ky.someone.mods.framingtemplates.recipe.FramingRecipes;
import ky.someone.mods.framingtemplates.util.DrawerSide;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TemplateDecorationRecipe
extends CustomRecipe {
    public TemplateDecorationRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        FramingTemplateItem template = null;
        int templateIdx = -1;
        boolean hasDecoration = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            DrawerSide[] stack = container.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof FramingTemplateItem)) continue;
            FramingTemplateItem templateItem = (FramingTemplateItem)item;
            if (templateIdx != -1) {
                return false;
            }
            templateIdx = i;
            template = templateItem;
        }
        if (template == null) {
            return false;
        }
        IntOpenHashSet validIndices = new IntOpenHashSet();
        for (DrawerSide side : template.getAllSides()) {
            int sideIdx = templateIdx + side.offsetY() * container.m_39346_() + side.offsetX() % container.m_39347_();
            if (sideIdx < 0 || sideIdx >= container.m_6643_()) continue;
            validIndices.add(sideIdx);
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41619_()) continue;
            if (validIndices.contains(i)) {
                hasDecoration = true;
                continue;
            }
            if (i == templateIdx) continue;
            return false;
        }
        return hasDecoration;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        FramingTemplateItem template = null;
        int templateIdx = -1;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof FramingTemplateItem)) continue;
            FramingTemplateItem templateItem = (FramingTemplateItem)item;
            templateIdx = i;
            template = templateItem;
            break;
        }
        if (template == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = template.m_7968_().m_41777_();
        for (DrawerSide side : template.getAllSides()) {
            ItemStack decoration;
            int sideIdx = templateIdx + side.offsetY() * container.m_39346_() + side.offsetX() % container.m_39347_();
            if (sideIdx < 0 || sideIdx >= container.m_6643_() || (decoration = container.m_8020_(sideIdx)).m_41619_()) continue;
            template.setDecoration(side, stack, decoration.m_255036_(1));
        }
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList stacks = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        boolean templateUsed = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            Item item;
            ItemStack stack = container.m_8020_(i);
            if (!templateUsed && (item = stack.m_41720_()) instanceof FramingTemplateItem) {
                FramingTemplateItem templateItem = (FramingTemplateItem)item;
                templateUsed = true;
                continue;
            }
            stacks.set(i, (Object)stack.m_255036_(1));
        }
        return stacks;
    }

    public boolean m_8004_(int i, int j) {
        return i >= 2 && j >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FramingRecipes.TEMPLATE_DECORATION.get();
    }
}

