/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates;

import java.util.Collection;
import java.util.List;
import ky.someone.mods.framingtemplates.item.FramingItems;
import ky.someone.mods.framingtemplates.item.FramingTemplateItem;
import ky.someone.mods.framingtemplates.recipe.FramingRecipes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="framing_templates")
public class FramingTemplates {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Framing Templates");

    public FramingTemplates() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        FramingItems.REGISTRY.register(modBus);
        FramingRecipes.REGISTRY.register(modBus);
        modBus.addListener(this::registerCreativeTab);
        MinecraftForge.EVENT_BUS.addListener(this::onRightClick);
    }

    private void registerCreativeTab(RegisterEvent event) {
        if (event.getRegistryKey() != Registries.f_279569_) {
            return;
        }
        event.register(Registries.f_279569_, helper -> {
            Collection entries = FramingItems.REGISTRY.getEntries();
            if (entries.isEmpty()) {
                return;
            }
            List<ItemStack> allItems = entries.stream().flatMap(RegistryObject::stream).map(Item::m_7968_).toList();
            helper.register("tab", (Object)CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)"Framing Templates")).m_257501_((params, output) -> output.m_246601_((Collection)allItems)).m_257737_(() -> (ItemStack)allItems.get(0)).m_257652_());
        });
    }

    private void onRightClick(PlayerInteractEvent.RightClickItem event) {
        FramingTemplateItem template;
        ItemStack applied;
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        Player player = event.getEntity();
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        Item item = offHandItem.m_41720_();
        if (item instanceof FramingTemplateItem && !(applied = (template = (FramingTemplateItem)item).applyTemplateToItem(offHandItem, mainHandItem)).equals(mainHandItem, false)) {
            if (!player.m_150110_().f_35937_) {
                if (offHandItem.m_41613_() < mainHandItem.m_41613_()) {
                    return;
                }
                offHandItem.m_41774_(mainHandItem.m_41613_());
            }
            player.m_21008_(InteractionHand.MAIN_HAND, applied);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

