/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.CompactingDrawerBlock;
import com.buuz135.functionalstorage.block.ControllerExtensionBlock;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.DrawerControllerBlock;
import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.block.SimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.tile.CompactingFramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedControllerExtensionTile;
import com.buuz135.functionalstorage.block.tile.FramedDrawerControllerTile;
import com.buuz135.functionalstorage.block.tile.FramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedSimpleCompactingDrawerTile;
import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import com.buuz135.functionalstorage.util.DrawerWoodType;
import java.util.HashMap;
import ky.someone.mods.framingtemplates.item.FramingTemplateItem;
import ky.someone.mods.framingtemplates.util.DrawerSide;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class FunctionalStorageTemplate
extends FramingTemplateItem {
    public static final DrawerSide SIDE = DrawerSide.of("side", 0, -1, '\u2b06');
    public static final DrawerSide FRONT = DrawerSide.of("front", 1, -1, '\u2b08');
    public static final DrawerSide FRONT_DIVIDER = DrawerSide.of("front_divider", 1, 0, '\u27a1');

    public FunctionalStorageTemplate(String modid) {
        super(modid);
    }

    @Override
    public boolean applyTemplateInWorld(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        Block block = this.convertToFramed(state.m_60734_());
        if (block == null) {
            return false;
        }
        FramedDrawerModelData modelData = this.makeModelData(stack);
        if (block != state.m_60734_()) {
            CompoundTag tag = be.m_187482_();
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            level.m_46597_(pos, block.m_152465_(state));
            be = level.m_7702_(pos);
            be.m_142466_(tag);
        }
        if (be instanceof FramedDrawerTile) {
            FramedDrawerTile framed = (FramedDrawerTile)be;
            framed.setFramedDrawerModelData(modelData);
        } else if (be instanceof FramedDrawerControllerTile) {
            FramedDrawerControllerTile framed = (FramedDrawerControllerTile)be;
            framed.setFramedDrawerModelData(modelData);
        } else if (be instanceof CompactingFramedDrawerTile) {
            CompactingFramedDrawerTile framed = (CompactingFramedDrawerTile)be;
            framed.setFramedDrawerModelData(modelData);
        } else if (be instanceof FramedSimpleCompactingDrawerTile) {
            FramedSimpleCompactingDrawerTile framed = (FramedSimpleCompactingDrawerTile)be;
            framed.setFramedDrawerModelData(modelData);
        } else if (be instanceof FramedControllerExtensionTile) {
            FramedControllerExtensionTile framed = (FramedControllerExtensionTile)be;
            framed.setFramedDrawerModelData(modelData);
        } else {
            return false;
        }
        be.requestModelDataUpdate();
        return true;
    }

    @Override
    public ItemStack applyTemplateToItem(ItemStack template, ItemStack target) {
        BlockItem blockItem;
        Block converted;
        Item item = target.m_41720_();
        if (item instanceof BlockItem && (converted = this.convertToFramed((blockItem = (BlockItem)item).m_40614_())) != null) {
            if (!target.m_150930_(converted.m_5456_())) {
                target = new ItemStack((ItemLike)converted, target.m_41613_(), target.m_41783_());
            }
            target.m_41784_().m_128365_("Style", (Tag)this.makeModelData(template).serializeNBT());
        }
        return target;
    }

    @Nullable
    private Block convertToFramed(Block input) {
        if (input instanceof FramedDrawerBlock) {
            FramedDrawerBlock framed = (FramedDrawerBlock)input;
            return framed;
        }
        if (input instanceof DrawerControllerBlock) {
            return (Block)((RegistryObject)FunctionalStorage.FRAMED_DRAWER_CONTROLLER.getKey()).get();
        }
        if (input instanceof ControllerExtensionBlock) {
            return (Block)((RegistryObject)FunctionalStorage.FRAMED_CONTROLLER_EXTENSION.getKey()).get();
        }
        if (input instanceof CompactingDrawerBlock) {
            return (Block)((RegistryObject)FunctionalStorage.FRAMED_COMPACTING_DRAWER.getKey()).get();
        }
        if (input instanceof SimpleCompactingDrawerBlock) {
            return (Block)((RegistryObject)FunctionalStorage.FRAMED_SIMPLE_COMPACTING_DRAWER.getKey()).get();
        }
        if (input instanceof DrawerBlock) {
            DrawerBlock drawer = (DrawerBlock)input;
            ResourceLocation id = new ResourceLocation("functionalstorage", DrawerWoodType.FRAMED.getName() + "_" + drawer.getType().getSlots());
            return (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        }
        return null;
    }

    private FramedDrawerModelData makeModelData(ItemStack template) {
        ItemStack side = this.getDecoration(SIDE, template);
        ItemStack front = this.getDecoration(FRONT, template);
        ItemStack trim = this.getDecoration(FRONT_DIVIDER, template);
        HashMap<String, Item> items = new HashMap<String, Item>();
        if (!side.m_41619_()) {
            Item sideItem = side.m_41720_();
            items.put("particle", sideItem);
            items.put("side", sideItem);
            items.put("front_divider", sideItem);
        }
        if (!front.m_41619_()) {
            items.put("front", front.m_41720_());
        }
        if (!trim.m_41619_()) {
            items.put("trim", trim.m_41720_());
        }
        return new FramedDrawerModelData(items);
    }

    @Override
    public DrawerSide[] getAllSides() {
        return new DrawerSide[]{SIDE, FRONT, FRONT_DIVIDER};
    }
}

