/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.network.PositionRequestMessage;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class PullItemRequestMessage {
    private ItemStack stack;
    private int amount;

    public PullItemRequestMessage(ItemStack stack, int amount) {
        this.stack = stack;
        this.amount = amount;
        TrackingList.trackItem(stack);
    }

    public PullItemRequestMessage() {
    }

    public static boolean compareItems(ItemStack first, ItemStack second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE) {
            return ItemStack.m_41656_((ItemStack)first, (ItemStack)second);
        }
        return ItemStack.m_150942_((ItemStack)first, (ItemStack)second);
    }

    public PullItemRequestMessage fromBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        this.stack = ItemStack.f_41583_;
        this.stack = packetBuffer.m_130267_();
        this.amount = packetBuffer.readInt();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        packetBuffer.m_130055_(this.stack);
        packetBuffer.writeInt(this.amount);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            AABB box = new AABB(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_20183_()).m_82400_((double)FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            int currentAmount = 0;
            for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                BlockEntity tileEntity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_().m_7702_(blockPos);
                if (tileEntity != null) {
                    for (IInventoryPuller blockExtractor : FindMeMod.BLOCK_EXTRACTORS) {
                        if ((currentAmount += blockExtractor.pull(tileEntity, this.stack, this.amount - currentAmount, ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer())) >= this.amount) break;
                    }
                }
                if (currentAmount < this.amount) continue;
                break;
            }
            if (currentAmount < this.amount) {
                Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
                Level level = player.m_9236_();
                level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
        });
    }
}

