/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.shape;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.shape.ShapeEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.shape.ShapeElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapeElementBuilder
extends ElementBuilder<ShapeElement, ShapeEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ShapeElementBuilder() {
        super("shape");
    }

    @Override
    @NotNull
    public ShapeElement buildDefaultInstance() {
        ShapeElement i = new ShapeElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        return i;
    }

    @Override
    public ShapeElement deserializeElement(@NotNull SerializedElement serialized) {
        String colorHex;
        ShapeElement element = this.buildDefaultInstance();
        String shape = serialized.getValue("shape");
        if (shape != null) {
            element.shape = ShapeElement.Shape.getByName(shape);
        }
        if ((colorHex = serialized.getValue("color")) != null) {
            element.color = DrawableColor.of(colorHex);
            if (element.color == null) {
                DrawableColor.of(255, 255, 255);
            }
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull ShapeElement element, @NotNull SerializedElement serializeTo) {
        if (element.shape != null) {
            serializeTo.putProperty("shape", element.shape.name);
        }
        if (element.color != null) {
            serializeTo.putProperty("color", element.color.getHex());
        }
        return serializeTo;
    }

    @Override
    @NotNull
    public ShapeEditorElement wrapIntoEditorElement(@NotNull ShapeElement element, @NotNull LayoutEditorScreen editor) {
        return new ShapeEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"fancymenu.editor.add.shape.rectangle");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.add.shape.rectangle.desc", new String[0]);
    }
}

