/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lol.bai.badpackets.api.PacketSender;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ChestLootTableSender
implements LootSender<ChestLootPoolBuilder> {
    private final String idToSend;
    final List<ChestLootPoolBuilder> builderList = new LinkedList<ChestLootPoolBuilder>();
    HashMap<ItemStack, Float> floatMap = new HashMap();
    public static ResourceLocation CHEST_SENDER = new ResourceLocation("e_l", "c_s");

    public ChestLootTableSender(ResourceLocation id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            builder.builtMap.forEach((item, weight) -> {
                if (this.floatMap.containsKey(item)) {
                    float oldWeight = this.floatMap.getOrDefault(item, Float.valueOf(0.0f)).floatValue();
                    this.floatMap.put((ItemStack)item, Float.valueOf(oldWeight + weight.floatValue()));
                } else {
                    this.floatMap.put((ItemStack)item, (Float)weight);
                }
            });
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (!PacketSender.s2c((ServerPlayer)player).canSend(CHEST_SENDER)) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(this.idToSend);
        buf.writeShort(this.floatMap.size());
        this.floatMap.forEach((item, floatWeight) -> {
            buf.m_130055_(item);
            buf.writeFloat(floatWeight.floatValue());
        });
        PacketSender.s2c((ServerPlayer)player).send(CHEST_SENDER, buf);
    }

    @Override
    public void addBuilder(ChestLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ChestLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

