/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.emi.ArchaeologyLootRecipe;
import fzzyhmstrs.emi_loot.emi.BlockLootRecipe;
import fzzyhmstrs.emi_loot.emi.ChestLootRecipe;
import fzzyhmstrs.emi_loot.emi.GameplayLootRecipe;
import fzzyhmstrs.emi_loot.emi.LootSimplifiedRenderer;
import fzzyhmstrs.emi_loot.emi.MobLootRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@EmiEntrypoint
public class EmiClientPlugin
implements EmiPlugin {
    private static final ResourceLocation LOOT_ID = new ResourceLocation("emi_loot", "chest_loot");
    private static final ResourceLocation BLOCK_ID = new ResourceLocation("emi_loot", "block_drops");
    private static final ResourceLocation MOB_ID = new ResourceLocation("emi_loot", "mob_drops");
    private static final ResourceLocation GAMEPLAY_ID = new ResourceLocation("emi_loot", "gameplay_drops");
    private static final ResourceLocation ARCHAEOLOGY_ID = new ResourceLocation("emi_loot", "archaeology_drops");
    public static final EmiRecipeCategory LOOT_CATEGORY = new EmiRecipeCategory(LOOT_ID, (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50087_.m_5456_()), (EmiRenderable)new LootSimplifiedRenderer(0, 0));
    public static final EmiRecipeCategory BLOCK_CATEGORY = new EmiRecipeCategory(BLOCK_ID, (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50089_.m_5456_()), (EmiRenderable)new LootSimplifiedRenderer(16, 0));
    public static final EmiRecipeCategory MOB_CATEGORY = new EmiRecipeCategory(MOB_ID, (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50314_.m_5456_()), (EmiRenderable)new LootSimplifiedRenderer(0, 16));
    public static final EmiRecipeCategory GAMEPLAY_CATEGORY = new EmiRecipeCategory(GAMEPLAY_ID, (EmiRenderable)EmiStack.of((ItemLike)Items.f_42523_), (EmiRenderable)new LootSimplifiedRenderer(16, 16));
    public static final EmiRecipeCategory ARCHAEOLOGY_CATEGORY = new EmiRecipeCategory(ARCHAEOLOGY_ID, (EmiRenderable)EmiStack.of((ItemLike)Items.f_271356_));

    public void register(EmiRegistry registry) {
        registry.addCategory(LOOT_CATEGORY);
        registry.addCategory(BLOCK_CATEGORY);
        registry.addCategory(MOB_CATEGORY);
        registry.addCategory(GAMEPLAY_CATEGORY);
        registry.addCategory(ARCHAEOLOGY_CATEGORY);
        EMILootClient.tables.getLoots().forEach(lootReceiver -> {
            if (!lootReceiver.isEmpty()) {
                if (lootReceiver instanceof ClientChestLootTable) {
                    registry.addRecipe((EmiRecipe)new ChestLootRecipe((ClientChestLootTable)lootReceiver));
                }
                if (lootReceiver instanceof ClientBlockLootTable) {
                    registry.addRecipe((EmiRecipe)new BlockLootRecipe((ClientBlockLootTable)lootReceiver));
                }
                if (lootReceiver instanceof ClientMobLootTable) {
                    registry.addRecipe((EmiRecipe)new MobLootRecipe((ClientMobLootTable)lootReceiver));
                }
                if (lootReceiver instanceof ClientGameplayLootTable) {
                    registry.addRecipe((EmiRecipe)new GameplayLootRecipe((ClientGameplayLootTable)lootReceiver));
                }
                if (lootReceiver instanceof ClientArchaeologyLootTable) {
                    registry.addRecipe((EmiRecipe)new ArchaeologyLootRecipe((ClientArchaeologyLootTable)lootReceiver));
                }
            }
        });
    }
}

