/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.EMILootExpectPlatform;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ChestLootRecipe
implements EmiRecipe {
    private final ClientChestLootTable loot;
    private final ArrayListMultimap<Float, EmiStack> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final Component title;
    private final float columns = 8.0f;

    public ChestLootRecipe(ClientChestLootTable loot) {
        MutableComponent rawTitle;
        this.loot = loot;
        if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
            this.isGuaranteedNonChance = true;
        }
        ArrayListMultimap map2 = ArrayListMultimap.create();
        LinkedList<EmiStack> outputsList = new LinkedList<EmiStack>();
        loot.items.forEach((item, weight) -> {
            EmiStack stack = EmiStack.of((ItemStack)item);
            map2.put(weight, (Object)stack);
            outputsList.add(stack);
        });
        this.lootStacksSorted = map2;
        this.lootStacksSortedSize = loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? this.lootStacksSorted.keySet().size() : loot.items.size();
        this.outputs = outputsList;
        String key = "emi_loot.chest." + loot.id.toString();
        MutableComponent text = LText.translatable(key);
        if (Objects.equals(text.getString(), key)) {
            if (EMILootExpectPlatform.isModLoaded(loot.id.m_135827_())) {
                String modName = EMILootExpectPlatform.getModName(loot.id.m_135827_());
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", modName);
            } else {
                MutableComponent unknown = LText.translatable("emi_loot.chest.unknown");
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", unknown.getString());
            }
        } else {
            rawTitle = text;
        }
        MutableComponent dots = LText.literal("...");
        int dotsWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)dots);
        if (Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)rawTitle) > 138 - dotsWidth) {
            String trimmed = Minecraft.m_91087_().f_91062_.m_92834_(rawTitle.getString(), 138 - dotsWidth) + "...";
            this.title = LText.literal(trimmed);
        } else {
            this.title = rawTitle;
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.LOOT_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation(EMILootClient.MOD_ID, "/" + this.getCategory().id.m_135815_() + "/" + this.loot.id.m_135827_() + "/" + this.loot.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.chestLootCompact ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.addText(this.title.m_7532_(), 1, 0, 0x404040, false);
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : this.lootStacksSorted.asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight);
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.percentage", fTrim)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), 2);
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.rolls", fTrim).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

