/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import nl.requios.effortlessbuilding.create.Create;
import nl.requios.effortlessbuilding.create.foundation.render.SuperByteBuffer;
import nl.requios.effortlessbuilding.create.foundation.utility.AnimationTickHolder;
import nl.requios.effortlessbuilding.create.foundation.utility.RegisteredObjects;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class TileEntityRenderHelper {
    public static void renderTileEntities(Level world, Iterable<BlockEntity> customRenderTEs, PoseStack ms, MultiBufferSource buffer) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer);
    }

    public static void renderTileEntities(Level world, Iterable<BlockEntity> customRenderTEs, PoseStack ms, MultiBufferSource buffer, float pt) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer, pt);
    }

    public static void renderTileEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderTEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, customRenderTEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderTileEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderTEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        Iterator<BlockEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            BlockEntity tileEntity = iterator.next();
            if (Backend.getBackendType() == BackendType.INSTANCING && Backend.isFlywheelWorld((LevelAccessor)renderWorld) && InstancedRenderRegistry.shouldSkipRender((BlockEntity)tileEntity)) continue;
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = tileEntity.m_58899_();
            ms.m_85836_();
            TransformStack.cast((PoseStack)ms).translate((Vec3i)pos);
            try {
                int worldLight = TileEntityRenderHelper.getCombinedLight(world, TileEntityRenderHelper.getLightPos(lightTransform, pos), renderWorld, pos);
                if (renderWorld != null) {
                    tileEntity.m_142339_((Level)renderWorld);
                    renderer.m_6922_(tileEntity, pt, ms, buffer, worldLight, OverlayTexture.f_118083_);
                    tileEntity.m_142339_(world);
                } else {
                    renderer.m_6922_(tileEntity, pt, ms, buffer, worldLight, OverlayTexture.f_118083_);
                }
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + RegisteredObjects.getKeyOrThrow(tileEntity.m_58903_()).toString() + " could not be rendered virtually.";
                Create.LOGGER.error(message, (Throwable)e);
            }
            ms.m_85849_();
        }
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.m_123341_() + 0.5f, (float)contraptionPos.m_123342_() + 0.5f, (float)contraptionPos.m_123343_() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.m_274561_((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }

    public static int getCombinedLight(Level world, BlockPos worldPos, @Nullable VirtualRenderWorld renderWorld, BlockPos renderWorldPos) {
        int worldLight = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)renderWorldPos);
            return SuperByteBuffer.maxLight(worldLight, renderWorldLight);
        }
        return worldLight;
    }
}

