/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import nl.requios.effortlessbuilding.create.foundation.gui.element.RenderElement;
import nl.requios.effortlessbuilding.create.foundation.utility.Color;
import nl.requios.effortlessbuilding.create.foundation.utility.Couple;
import org.joml.Matrix4f;

public class BoxElement
extends RenderElement {
    protected Color background = new Color(-16777216, true);
    protected Color borderTop = new Color(1090514653, true);
    protected Color borderBot = new Color(553643741, true);
    protected int borderOffset = 2;

    public <T extends BoxElement> T withBackground(Color color) {
        this.background = color;
        return (T)this;
    }

    public <T extends BoxElement> T withBackground(int color) {
        return this.withBackground(new Color(color, true));
    }

    public <T extends BoxElement> T flatBorder(Color color) {
        this.borderTop = color;
        this.borderBot = color;
        return (T)this;
    }

    public <T extends BoxElement> T flatBorder(int color) {
        return this.flatBorder(new Color(color, true));
    }

    public <T extends BoxElement> T gradientBorder(Couple<Color> colors) {
        this.borderTop = (Color)colors.getFirst();
        this.borderBot = (Color)colors.getSecond();
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(Color top, Color bot) {
        this.borderTop = top;
        this.borderBot = bot;
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(int top, int bot) {
        return this.gradientBorder(new Color(top, true), new Color(bot, true));
    }

    public <T extends BoxElement> T withBorderOffset(int offset) {
        this.borderOffset = offset;
        return (T)this;
    }

    @Override
    public void render(GuiGraphics graphics) {
        this.renderBox(graphics.m_280168_());
    }

    protected void renderBox(PoseStack ms) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f model = ms.m_85850_().m_252922_();
        int f = this.borderOffset;
        Color c1 = this.background.copy().scaleAlpha(this.alpha);
        Color c2 = this.borderTop.copy().scaleAlpha(this.alpha);
        Color c3 = this.borderBot.copy().scaleAlpha(this.alpha);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder b = tessellator.m_85915_();
        b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f - 2.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 2.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 2.0f, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 2.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + 2.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 2.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 2.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 2.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).m_6122_(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()).m_5752_();
        tessellator.m_85914_();
        b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f - 1.0f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f - 1.0f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x - (float)f - 1.0f, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + 1.0f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + (float)this.width, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + (float)this.width, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y + (float)f + (float)this.height, this.z).m_6122_(c3.getRed(), c3.getGreen(), c3.getBlue(), c3.getAlpha()).m_5752_();
        b.m_252986_(model, this.x + (float)f + 1.0f + (float)this.width, this.y - (float)f, this.z).m_6122_(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }
}

