/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import tfar.craftingstation.util.CraftingStationItemHandler;

public class CraftingInventoryPersistant
extends TransientCraftingContainer {
    private boolean doNotCallUpdates;
    protected final CraftingStationItemHandler inv;

    public CraftingInventoryPersistant(AbstractContainerMenu eventHandler, CraftingStationItemHandler itemHandler) {
        super(eventHandler, 3, 3);
        this.inv = itemHandler;
        this.doNotCallUpdates = false;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        this.validate(slot);
        return this.inv.getStackInSlot(slot);
    }

    public void validate(int slot) {
        if (this.isValid(slot)) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to poll an outofbounds stack at slot " + slot + " report to them, NOT Crafting Station");
    }

    public boolean isValid(int slot) {
        return slot >= 0 && slot < this.m_6643_();
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        this.validate(slot);
        ItemStack stack = this.inv.extractItem(slot, count, false);
        if (!stack.m_41619_()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        this.validate(slot);
        this.inv.setStackInSlot(slot, stack);
        this.onCraftMatrixChanged();
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        this.validate(index);
        ItemStack s = this.m_8020_(index);
        if (s.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.onCraftMatrixChanged();
        this.m_6836_(index, ItemStack.f_41583_);
        return s;
    }

    public NonNullList<ItemStack> getStackList() {
        return this.inv.getContents();
    }

    public boolean m_7983_() {
        return IntStream.range(0, this.inv.getSlots()).allMatch(i -> this.inv.getStackInSlot(i).m_41619_());
    }

    public void m_6211_() {
    }

    public void setDoNotCallUpdates(boolean doNotCallUpdates) {
        this.doNotCallUpdates = doNotCallUpdates;
    }

    public void onCraftMatrixChanged() {
        if (!this.doNotCallUpdates) {
            this.f_286998_.m_6199_((Container)this);
        }
    }
}

