/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.DecimalValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class FloatValue
extends DecimalValue<Float> {
    public FloatValue(ValueData<Float> valueData) {
        super(valueData, DecimalValue.Range.unboundedFloat());
    }

    @Override
    public Float getCorrectedValue(Float in) {
        if (this.range == null) {
            return in;
        }
        if (!this.range.isWithin(in.floatValue())) {
            float corrected = this.range.clamp(in.floatValue());
            ConfigUtils.logCorrectedMessage(this.getId(), in, Float.valueOf(corrected));
            return Float.valueOf(corrected);
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeFloat(this.getId(), ((Float)this.get()).floatValue());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(Float.valueOf(format.readFloat(this.getId())));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new FloatValue(ValueData.of(name, Float.valueOf(((Float)value).floatValue()), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeFloat(((Float)value.get()).floatValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setFloat(instance, ((Float)value).floatValue());
        }
    }
}

