/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn.pack.cits;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import shcm.shsupercm.forge.citresewn.ex.CITParseException;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;

public class CITArmor
extends CIT {
    public final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

    public CITArmor(CITPack pack, ResourceLocation identifier, Properties properties) throws CITParseException {
        super(pack, identifier, properties);
        try {
            if (this.items.size() == 0) {
                throw new Exception("CIT must target at least one item type");
            }
            for (Item item : this.items) {
                if (item instanceof ArmorItem) continue;
                throw new Exception("Armor CIT must target armor items only(" + BuiltInRegistries.f_257033_.m_7981_((Object)item) + " is not armor)");
            }
            for (Object o : properties.keySet()) {
                String property;
                if (!(o instanceof String) || !(property = (String)o).startsWith("texture.")) continue;
                ResourceLocation textureIdentifier = CITArmor.resolvePath(identifier, properties.getProperty(property), ".png", Minecraft.m_91087_().m_91098_());
                if (textureIdentifier == null) {
                    throw new Exception("Cannot resolve path for " + property);
                }
                this.textures.put(property.substring(8), textureIdentifier);
            }
        }
        catch (Exception e) {
            throw new CITParseException(pack.resourcePack, identifier, (String)(e.getClass() == Exception.class ? "" : e.getClass().getSimpleName() + ": ") + e.getMessage());
        }
    }

    public static interface Cached {
        public CITArmor citresewn_getCachedCITArmor(Supplier<CITArmor> var1);
    }
}

