/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services;

import appeng.core.worlddata.AESavedData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

class ChunkLoadState
extends AESavedData {
    public static final String NAME = "ae2_chunk_load_state";
    private final ServerLevel level;
    private final Long2ObjectMap<Set<BlockPos>> forceLoadedChunks = new Long2ObjectOpenHashMap();

    public static ChunkLoadState get(ServerLevel level) {
        return (ChunkLoadState)level.m_8895_().m_164861_(tag -> new ChunkLoadState(level, (CompoundTag)tag), () -> new ChunkLoadState(level), NAME);
    }

    private ChunkLoadState(ServerLevel level) {
        this.level = level;
    }

    private ChunkLoadState(ServerLevel level, CompoundTag tag) {
        this(level);
        ListTag forcedChunks = tag.m_128437_("forcedChunks", 10);
        for (int i = 0; i < forcedChunks.size(); ++i) {
            CompoundTag forcedChunk = forcedChunks.m_128728_(i);
            ChunkPos chunkPos = new ChunkPos(forcedChunk.m_128451_("cx"), forcedChunk.m_128451_("cz"));
            HashSet<BlockPos> blockSet = new HashSet<BlockPos>();
            ListTag blocks = forcedChunk.m_128437_("blocks", 10);
            for (int j = 0; j < blocks.size(); ++j) {
                blockSet.add(NbtUtils.m_129239_((CompoundTag)blocks.m_128728_(j)));
            }
            this.forceLoadedChunks.put(chunkPos.m_45588_(), blockSet);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag forcedChunks = new ListTag();
        for (Long2ObjectMap.Entry entry : this.forceLoadedChunks.long2ObjectEntrySet()) {
            ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
            CompoundTag forcedChunk = new CompoundTag();
            forcedChunk.m_128405_("cx", chunkPos.f_45578_);
            forcedChunk.m_128405_("cz", chunkPos.f_45579_);
            ListTag list = new ListTag();
            for (BlockPos pos : (Set)entry.getValue()) {
                list.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            forcedChunk.m_128365_("blocks", (Tag)list);
            forcedChunks.add((Object)forcedChunk);
        }
        tag.m_128365_("forcedChunks", (Tag)forcedChunks);
        return tag;
    }

    public void forceChunk(ChunkPos chunkPos, BlockPos sourcePos) {
        long chunk = chunkPos.m_45588_();
        ((Set)this.forceLoadedChunks.computeIfAbsent(chunk, pos -> new HashSet())).add(sourcePos.m_7949_());
        this.level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        this.m_77762_();
    }

    public void releaseChunk(ChunkPos chunkPos, BlockPos sourcePos) {
        Set map = (Set)this.forceLoadedChunks.get(chunkPos.m_45588_());
        if (map == null) {
            return;
        }
        map.remove(sourcePos);
        if (map.isEmpty()) {
            this.forceLoadedChunks.remove(chunkPos.m_45588_());
            this.level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        }
        this.m_77762_();
    }

    public void releaseAll(BlockPos sourcePos) {
        long[] relevantChunks;
        for (long chunk : relevantChunks = this.forceLoadedChunks.long2ObjectEntrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(sourcePos)).mapToLong(Long2ObjectMap.Entry::getLongKey).toArray()) {
            this.releaseChunk(new ChunkPos(chunk), sourcePos);
        }
    }

    public Map<BlockPos, LongSet> getAllBlocks() {
        HashMap<BlockPos, LongSet> blocks = new HashMap<BlockPos, LongSet>();
        for (Long2ObjectMap.Entry entry : this.forceLoadedChunks.long2ObjectEntrySet()) {
            for (BlockPos blockPos : (Set)entry.getValue()) {
                blocks.computeIfAbsent(blockPos, pos -> new LongOpenHashSet()).add(entry.getLongKey());
            }
        }
        return blocks;
    }

    public boolean isForceLoaded(int cx, int cz) {
        return this.forceLoadedChunks.containsKey(ChunkPos.m_45589_((int)cx, (int)cz));
    }
}

