/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class LytBox
extends LytBlock
implements LytBlockContainer {
    protected final List<LytBlock> children = new ArrayList<LytBlock>();
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;

    @Override
    public void removeChild(LytNode node) {
        if (node instanceof LytBlock) {
            LytBlock block = (LytBlock)node;
            if (block.parent == this) {
                this.children.remove(block);
                block.parent = null;
            }
        }
    }

    @Override
    public void append(LytBlock block) {
        if (block.parent != null) {
            block.parent.removeChild(block);
        }
        block.parent = this;
        this.children.add(block);
    }

    public void clearContent() {
        for (LytBlock child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    protected abstract LytRect computeBoxLayout(LayoutContext var1, int var2, int var3, int var4);

    @Override
    protected final LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect innerLayout = this.computeBoxLayout(context, x + this.paddingLeft, y + this.paddingTop, availableWidth - this.paddingLeft - this.paddingRight);
        return innerLayout.expand(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        for (LytBlock child : this.children) {
            child.setLayoutPos(child.bounds.point().add(deltaX, deltaY));
        }
    }

    public final void setPadding(int padding) {
        this.paddingLeft = padding;
        this.paddingTop = padding;
        this.paddingRight = padding;
        this.paddingBottom = padding;
    }

    @Override
    public List<? extends LytNode> getChildren() {
        return this.children;
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        for (LytBlock child : this.children) {
            child.renderBatch(context, buffers);
        }
    }

    @Override
    public void render(RenderContext context) {
        for (LytBlock child : this.children) {
            child.render(context);
        }
    }
}

