/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.multiloader;

import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;

public enum Env {
    CLIENT,
    SERVER;

    public static final Env CURRENT;

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public void runIfCurrent(Supplier<Runnable> run) {
        if (this.isCurrent()) {
            run.get().run();
        }
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (CURRENT) {
            default -> throw new IncompatibleClassChangeError();
            case CLIENT -> clientTarget.get().get();
            case SERVER -> serverTarget.get().get();
        };
    }

    @ApiStatus.Internal
    public static Env getCurrent() {
        return FMLEnvironment.dist == Dist.CLIENT ? CLIENT : SERVER;
    }

    static {
        CURRENT = Env.getCurrent();
    }
}

