/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.travellersbootsreloaded.registry;

import dev.architectury.event.events.common.TickEvent;
import dev.denismasterherobrine.travellersbootsreloaded.TravellersBootsReloaded;
import dev.denismasterherobrine.travellersbootsreloaded.registry.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class EventRegistry {
    static boolean isStepHeightEnabled = TravellersBootsReloaded.config.getBoolean("isStepHeightEnabled");
    static int[] speedModifiers = new int[]{TravellersBootsReloaded.config.getInteger("speedModifierTier1"), TravellersBootsReloaded.config.getInteger("speedModifierTier2"), TravellersBootsReloaded.config.getInteger("speedModifierTier3"), TravellersBootsReloaded.config.getInteger("speedModifierTier4"), TravellersBootsReloaded.config.getInteger("speedModifierTier5")};
    static int[] jumpModifiers = new int[]{0, 0, 0, TravellersBootsReloaded.config.getInteger("jumpModifierTier4"), TravellersBootsReloaded.config.getInteger("jumpModifierTier5")};

    public static void register() {
        HashSet uuids = new HashSet();
        TickEvent.PLAYER_PRE.register(player -> {
            UUID uuid = player.m_20148_();
            int currentBootsTier = EventRegistry.getBootsTier(player);
            if (currentBootsTier > 0) {
                uuids.add(uuid);
            } else {
                uuids.remove(uuid);
            }
            if (isStepHeightEnabled) {
                player.m_274367_(player.m_6144_() ? 0.6f : (currentBootsTier > 1 ? 1.25f : 0.75f));
            }
        });
        TickEvent.SERVER_POST.register(server -> {
            for (UUID uuid : uuids) {
                int currentBootsTier;
                ServerPlayer player = server.m_6846_().m_11259_(uuid);
                if (player == null || (currentBootsTier = EventRegistry.getBootsTier((Player)player)) <= 0) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, speedModifiers[currentBootsTier - 1]));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 20, jumpModifiers[currentBootsTier - 1]));
            }
        });
    }

    private static int getBootsTier(Player player) {
        Item[] TRAVELLERS_BOOTS = new Item[]{(Item)ItemRegistry.TRAVELLERS_BOOTS_TIER_1.get(), (Item)ItemRegistry.TRAVELLERS_BOOTS_TIER_2.get(), (Item)ItemRegistry.TRAVELLERS_BOOTS_TIER_3.get(), (Item)ItemRegistry.TRAVELLERS_BOOTS_TIER_4.get(), (Item)ItemRegistry.TRAVELLERS_BOOTS_TIER_5.get()};
        int i = 4;
        while (i >= 0) {
            int finalI = i--;
            if (!StreamSupport.stream(player.m_6168_().spliterator(), false).anyMatch(itemStack -> itemStack.m_41720_().m_7968_().m_41720_() == TRAVELLERS_BOOTS[finalI])) continue;
            return i + 1;
        }
        return 0;
    }
}

