/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.travellersbootsreloaded.config;

import dev.architectury.platform.Platform;
import dev.denismasterherobrine.travellersbootsreloaded.config.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;

public class ArchConfiguration {
    private final Map<String, String> defaultProperties;
    private final SortedProperties properties = new SortedProperties();
    private final File configFile;

    public static Path getConfigDirectory() {
        return Platform.getConfigFolder();
    }

    public ArchConfiguration(String filename) {
        Path configDirectory = ArchConfiguration.getConfigDirectory();
        this.configFile = configDirectory.resolve(filename).toFile();
        try {
            if (this.configFile.exists()) {
                FileInputStream fis = new FileInputStream(this.configFile);
                this.properties.load(fis);
                fis.close();
            } else {
                this.setDefaults();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.defaultProperties = new HashMap<String, String>();
        this.defaultProperties.put("isStepHeightEnabled", "true");
        this.defaultProperties.put("speedModifierTier1", "1");
        this.defaultProperties.put("speedModifierTier2", "2");
        this.defaultProperties.put("speedModifierTier3", "3");
        this.defaultProperties.put("speedModifierTier4", "4");
        this.defaultProperties.put("speedModifierTier5", "5");
        this.defaultProperties.put("jumpModifierTier4", "1");
        this.defaultProperties.put("jumpModifierTier5", "2");
        this.reloadConfig();
    }

    public void setDefaults() {
        this.setProperty("isStepHeightEnabled", "true");
        this.setProperty("speedModifierTier1", "1");
        this.setProperty("speedModifierTier2", "2");
        this.setProperty("speedModifierTier3", "3");
        this.setProperty("speedModifierTier4", "4");
        this.setProperty("speedModifierTier5", "5");
        this.setProperty("jumpModifierTier4", "1");
        this.setProperty("jumpModifierTier5", "2");
        String comments = " Welcome to the Traveller's Boots Reloaded configuration. \n isStepHeightEnabled: Is Step Height boots ability should be enabled or not?";
        this.saveProperties(comments);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBoolean(String key) {
        String property = this.getProperty(key);
        try {
            return Boolean.parseBoolean(property);
        }
        catch (Exception e) {
            Logger.getLogger("travellersbootsreloaded").warning("[Traveller's Boots: Reloaded - ArchConfiguration] Failed to parse boolean property " + key + " with value " + property + ". Resetting to default.");
            this.setProperty(key, this.defaultProperties.get(key));
            this.saveProperties();
            return Boolean.parseBoolean(this.defaultProperties.get(key));
        }
    }

    public int getInteger(String key) {
        String property = this.getProperty(key);
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            Logger.getLogger("travellersbootsreloaded").warning("[Traveller's Boots: Reloaded - ArchConfiguration] Failed to parse Integer property " + key + " with value " + property + ". Resetting to default.");
            String defaultValue = this.defaultProperties.get(key);
            if (defaultValue != null) {
                this.setProperty(key, defaultValue);
                this.saveProperties();
                return Integer.parseInt(defaultValue);
            }
            Logger.getLogger("travellersbootsreloaded").severe("[Traveller's Boots: Reloaded - ArchConfiguration] Default value for Integer property " + key + " is not defined. Please define it in defaultProperties.");
            return 0;
        }
    }

    public void saveProperties() {
        this.saveProperties(null);
    }

    public void saveProperties(String comments) {
        try {
            FileOutputStream fos = new FileOutputStream(this.configFile);
            this.properties.store(fos, comments);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        try {
            if (this.configFile.exists()) {
                FileInputStream fis = new FileInputStream(this.configFile);
                this.properties.load(fis);
                fis.close();
                for (String key : this.defaultProperties.keySet()) {
                    if (this.properties.containsKey(key)) continue;
                    String defaultValue = this.defaultProperties.get(key);
                    this.properties.setProperty(key, defaultValue);
                    Logger.getLogger("travellersbootsreloaded").info("[Traveller's Boots: Reloaded - ArchConfiguration] Property " + key + " added with default value " + defaultValue);
                }
                HashSet<String> keys = new HashSet<String>(this.properties.stringPropertyNames());
                for (String key : keys) {
                    if (this.defaultProperties.containsKey(key)) continue;
                    this.properties.remove(key);
                    Logger.getLogger("travellersbootsreloaded").info("[Traveller's Boots: Reloaded - ArchConfiguration] Property " + key + " removed because it's not in default properties");
                }
                this.saveProperties();
            } else {
                this.setDefaults();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

