/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.ControllableSupport;
import dev.gigaherz.toolbelt.client.RadialMenuScreen;
import dev.gigaherz.toolbelt.client.ToolBeltLayer;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="toolbelt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    public static KeyMapping OPEN_TOOL_MENU_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_LEFT_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_RIGHT_KEYBIND;
    public static KeyMapping OPEN_BELT_SLOT_KEYBIND;
    private static boolean toolMenuKeyWasDown;
    public static ModelLayerLocation BELT_LAYER;

    public static void wipeOpen() {
        while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
        }
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            boolean toolMenuKeyIsDown = OPEN_TOOL_MENU_KEYBIND.m_90857_();
            if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
                while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
                    ItemStack inHand;
                    if (mc.f_91080_ != null || !ConfigData.isItemStackAllowed(inHand = mc.f_91074_.m_21205_())) continue;
                    BeltFinder.findBelt((LivingEntity)mc.f_91074_).ifPresent(getter -> mc.m_91152_((Screen)new RadialMenuScreen((BeltFinder.BeltGetter)getter)));
                }
            }
            toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            toolMenuKeyWasDown = true;
        }
        if (ConfigData.customBeltSlotEnabled) {
            while (OPEN_BELT_SLOT_KEYBIND.m_90859_()) {
                if (mc.f_91080_ != null) continue;
                ToolBelt.channel.sendToServer((Object)new OpenBeltSlotInventory());
            }
        }
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        Boolean triStateDown;
        if (keybind.m_90862_()) {
            return false;
        }
        if (ToolBelt.controllableEnabled && Boolean.TRUE.equals(triStateDown = ControllableSupport.isButtonDown(keybind))) {
            return true;
        }
        boolean isDown = switch (keybind.getKey().m_84868_()) {
            case InputConstants.Type.KEYSYM -> InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> keybind.m_90857_();
        };
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    static {
        toolMenuKeyWasDown = false;
        BELT_LAYER = new ModelLayerLocation(new ResourceLocation("minecraft:player"), "toolbelt_belt");
    }

    @Mod.EventBusSubscriber(modid="toolbelt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void initKeybinds(RegisterKeyMappingsEvent event) {
            OPEN_TOOL_MENU_KEYBIND = new KeyMapping("key.toolbelt.open", 82, "key.toolbelt.category");
            event.register(OPEN_TOOL_MENU_KEYBIND);
            CYCLE_TOOL_MENU_LEFT_KEYBIND = new KeyMapping("key.toolbelt.cycle.left", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
            event.register(CYCLE_TOOL_MENU_LEFT_KEYBIND);
            CYCLE_TOOL_MENU_RIGHT_KEYBIND = new KeyMapping("key.toolbelt.cycle.right", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
            event.register(CYCLE_TOOL_MENU_RIGHT_KEYBIND);
            OPEN_BELT_SLOT_KEYBIND = new KeyMapping("key.toolbelt.slot", 86, "key.toolbelt.category");
            event.register(OPEN_BELT_SLOT_KEYBIND);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ToolBelt.BELT.get()), (ResourceLocation)ToolBelt.location("has_custom_color"), (pStack, pLevel, pEntity, pSeed) -> {
                DyeableLeatherItem dyeable;
                Item patt6294$temp = pStack.m_41720_();
                return patt6294$temp instanceof DyeableLeatherItem && (dyeable = (DyeableLeatherItem)patt6294$temp).m_41113_(pStack) ? 1 : 0;
            }));
        }

        @SubscribeEvent
        public static void colors(RegisterColorHandlersEvent.Item event) {
            event.register((pStack, pTintIndex) -> {
                DyeableLeatherItem dyeable;
                Item patt6730$temp;
                return pTintIndex == 0 && (patt6730$temp = pStack.m_41720_()) instanceof DyeableLeatherItem && (dyeable = (DyeableLeatherItem)patt6730$temp).m_41113_(pStack) ? dyeable.m_41121_(pStack) : -1;
            }, new ItemLike[]{(ItemLike)ToolBelt.BELT.get()});
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BELT_LAYER, ToolBeltLayer.BeltModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void construct(EntityRenderersEvent.AddLayers event) {
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20529_, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20501_, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20524_, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20458_, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20562_, ToolBeltLayer::new);
            ModBusEvents.addLayerToHumanoid(event, EntityType.f_20481_, ToolBeltLayer::new);
            ModBusEvents.addLayerToPlayerSkin(event, "default", ToolBeltLayer::new);
            ModBusEvents.addLayerToPlayerSkin(event, "slim", ToolBeltLayer::new);
        }

        private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            LivingEntityRenderer renderer = event.getSkin(skinName);
            if (renderer != null) {
                renderer.m_115326_(factory.apply(renderer));
            }
        }

        private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            LivingEntityRenderer renderer = event.getRenderer(entityType);
            if (renderer != null) {
                renderer.m_115326_(factory.apply(renderer));
            }
        }

        private static <E extends LivingEntity, M extends EntityModel<E>> void addLayerToLiving(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
            LivingEntityRenderer renderer = event.getRenderer(entityType);
            if (renderer != null) {
                renderer.m_115326_(factory.apply(renderer));
            }
        }
    }
}

