/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.util;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.cake.BlockCakeBase;
import com.mrbysco.telepastries.config.TeleConfig;
import it.unimi.dsi.fastutil.longs.Long2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class CakeTeleporter
implements ITeleporter {
    private static final Object2ObjectMap<ResourceKey<Level>, LevelTeleportFinder> LEVEL_TELEPORTERS = (Object2ObjectMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> map.put((Object)ServerLevel.f_46430_, (entity, destWorld, minMaxBounds, cacheMap) -> CakeTeleporter.toEnd(entity, destWorld)));

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        BlockPos spawnPos = CakeTeleporter.getDimensionPosition(entity, (ResourceKey<Level>)destWorld.m_46472_());
        Long2BooleanArrayMap safeLocation = new Long2BooleanArrayMap();
        Pair minMaxBounds = CakeTeleporter.customCompatBounds(destWorld).mapFirst(min -> Math.max(min, destWorld.m_141937_())).mapSecond(max -> Math.min(max, destWorld.m_151558_()));
        if (spawnPos != null && destWorld.m_8055_(spawnPos.m_121945_(Direction.DOWN)).m_280296_() && CakeTeleporter.isPositionSafe(entity, destWorld, spawnPos, safeLocation, (Pair<Integer, Integer>)minMaxBounds)) {
            return CakeTeleporter.postProcessAndMake(destWorld, spawnPos, entity);
        }
        @Nullable PortalInfo levelInfo = ((LevelTeleportFinder)LEVEL_TELEPORTERS.getOrDefault((Object)destWorld.m_46472_(), CakeTeleporter::searchAroundAndDown)).determineTeleportLocation(entity, destWorld, (Pair<Integer, Integer>)minMaxBounds, safeLocation);
        if (levelInfo != null) {
            return levelInfo;
        }
        BlockPos teleportPos = destWorld.m_6857_().m_61937_(entity.m_20183_()) && (Integer)minMaxBounds.getFirst() < entity.m_20183_().m_123342_() - 1 && (float)((Integer)minMaxBounds.getSecond()).intValue() > (float)entity.m_20183_().m_123342_() + entity.m_20206_() + 1.0f ? entity.m_20183_() : new BlockPos(0, Math.max((Integer)minMaxBounds.getFirst(), 70), 0);
        float halfWidth = entity.m_20205_() / 2.0f;
        int minX = Mth.m_14143_((float)((float)teleportPos.m_123341_() - halfWidth - 1.0f));
        int minY = teleportPos.m_123342_() - 1;
        int minZ = Mth.m_14143_((float)((float)teleportPos.m_123343_() - halfWidth - 1.0f));
        int maxX = Mth.m_14167_((float)((float)teleportPos.m_123341_() + halfWidth + 1.0f));
        int maxY = Mth.m_14167_((float)((float)teleportPos.m_123342_() + entity.m_20206_() + 1.0f));
        int maxZ = Mth.m_14167_((float)((float)teleportPos.m_123343_() + halfWidth + 1.0f));
        for (BlockPos pedestalPos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState pedestalState;
            if (!destWorld.m_6857_().m_61937_(pedestalPos) || (pedestalState = destWorld.m_8055_(pedestalPos)).m_60734_() instanceof BlockCakeBase) continue;
            if (pedestalPos.m_123342_() == minY && !pedestalState.m_280296_()) {
                destWorld.m_46597_(pedestalPos, Blocks.f_50080_.m_49966_());
                continue;
            }
            if (!(pedestalPos.m_123342_() != maxY && pedestalPos.m_123341_() != minX && pedestalPos.m_123341_() != maxX && pedestalPos.m_123343_() != minZ && pedestalPos.m_123343_() != maxZ || pedestalState.m_280296_())) {
                destWorld.m_46597_(pedestalPos, Blocks.f_50652_.m_49966_());
                continue;
            }
            if (pedestalState.m_60734_().m_48673_(pedestalState)) continue;
            destWorld.m_46597_(pedestalPos, Blocks.f_50016_.m_49966_());
        }
        return CakeTeleporter.postProcessAndMake(destWorld, teleportPos, entity);
    }

    @Nullable
    private static PortalInfo searchAroundAndDown(Entity entity, ServerLevel destWorld, Pair<Integer, Integer> minMaxBounds, Long2BooleanArrayMap cacheMap) {
        double dimensionScale = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)destWorld.m_6042_());
        BlockPos spawnPos = destWorld.m_6857_().m_187569_((double)entity.m_20183_().m_123341_() * dimensionScale, (double)entity.m_20183_().m_123342_(), (double)entity.m_20183_().m_123343_() * dimensionScale).m_175288_(Math.min((Integer)minMaxBounds.getSecond(), destWorld.m_141937_() + destWorld.m_143344_()) - 1);
        for (BlockPos.MutableBlockPos checkPos : BlockPos.m_121935_((BlockPos)spawnPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            destWorld.m_46865_((BlockPos)checkPos);
            for (int heightY = Math.min(spawnPos.m_123342_(), destWorld.m_6924_(Heightmap.Types.MOTION_BLOCKING, checkPos.m_123341_(), checkPos.m_123343_())); heightY > (Integer)minMaxBounds.getFirst(); --heightY) {
                checkPos.m_142448_(heightY);
                if (!destWorld.m_8055_(checkPos.m_7949_().m_121945_(Direction.DOWN)).m_280296_() || !CakeTeleporter.isPositionSafe(entity, destWorld, (BlockPos)checkPos, cacheMap, minMaxBounds)) continue;
                return CakeTeleporter.postProcessAndMake(destWorld, (BlockPos)checkPos, entity);
            }
        }
        return null;
    }

    @Deprecated
    private static PortalInfo toEnd(Entity entity, ServerLevel destWorld) {
        BlockPos teleportPos = ServerLevel.f_8562_;
        float halfWidth = entity.m_20205_() / 2.0f;
        int minY = teleportPos.m_123342_() - 1;
        for (BlockPos pedestalPos : BlockPos.m_121976_((int)Mth.m_14143_((float)((float)teleportPos.m_123341_() - halfWidth)), (int)minY, (int)Mth.m_14143_((float)((float)teleportPos.m_123343_() - halfWidth)), (int)Mth.m_14167_((float)((float)teleportPos.m_123341_() + halfWidth)), (int)Mth.m_14167_((float)((float)teleportPos.m_123342_() + entity.m_20206_() + 1.0f)), (int)Mth.m_14167_((float)((float)teleportPos.m_123343_() + halfWidth)))) {
            BlockState pedestalState = destWorld.m_8055_(pedestalPos);
            if (pedestalState.m_60734_() instanceof BlockCakeBase) continue;
            if (pedestalPos.m_123342_() == minY && !pedestalState.m_280296_()) {
                destWorld.m_46597_(pedestalPos, Blocks.f_50080_.m_49966_());
                continue;
            }
            if (pedestalState.m_60734_().m_48673_(pedestalState)) continue;
            destWorld.m_46597_(pedestalPos, Blocks.f_50016_.m_49966_());
        }
        return CakeTeleporter.postProcessAndMake(destWorld, teleportPos, entity);
    }

    private static boolean isPositionSafe(Entity entity, ServerLevel destWorld, BlockPos checkPos, Long2BooleanArrayMap cacheMap, Pair<Integer, Integer> minMaxBounds) {
        float halfWidth = entity.m_20205_() / 2.0f;
        for (BlockPos entityBoxPos : BlockPos.m_121976_((int)Math.round((float)checkPos.m_123341_() - halfWidth), (int)checkPos.m_123342_(), (int)Math.round((float)checkPos.m_123343_() - halfWidth), (int)Math.round((float)checkPos.m_123341_() + halfWidth), (int)Math.round((float)checkPos.m_123342_() + entity.m_20206_()), (int)Math.round((float)checkPos.m_123343_() + halfWidth))) {
            if (cacheMap.computeIfAbsent(entityBoxPos.m_121878_(), c -> {
                if (!destWorld.m_6857_().m_61937_(entityBoxPos) || (Integer)minMaxBounds.getFirst() >= entityBoxPos.m_123342_()) {
                    return false;
                }
                BlockState entityBoxState = destWorld.m_8055_(entityBoxPos);
                return entityBoxState.m_60734_().m_48673_(entityBoxState);
            })) continue;
            return false;
        }
        return true;
    }

    public Entity placeEntity(Entity newEntity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        newEntity.f_19789_ = 0.0f;
        if (newEntity instanceof LivingEntity) {
            ((LivingEntity)newEntity).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 200, false, false));
        }
        return repositionEntity.apply(false);
    }

    public static void addDimensionPosition(Entity entityIn, ResourceKey<Level> dim, BlockPos position) {
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleporter.getTag(entityData);
        ResourceLocation dimLocation = dim.m_135782_();
        if (dim == Level.f_46430_) {
            BlockPos spawnPlatform = ServerLevel.f_8562_;
            TelePastries.LOGGER.debug("Setting {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, spawnPlatform});
            data.m_128356_("telepastries:" + dimLocation, spawnPlatform.m_121878_());
        } else {
            TelePastries.LOGGER.debug("Setting {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, position});
            data.m_128356_("telepastries:" + dimLocation, position.m_121878_());
        }
        entityData.m_128365_("PlayerPersisted", (Tag)data);
    }

    @Nullable
    public static BlockPos getDimensionPosition(Entity entityIn, ResourceKey<Level> dim) {
        ResourceLocation dimLocation;
        CompoundTag entityData = entityIn.getPersistentData();
        CompoundTag data = CakeTeleporter.getTag(entityData);
        if (data.m_128441_("telepastries:" + (dimLocation = dim.m_135782_()))) {
            BlockPos dimPos = BlockPos.m_122022_((long)data.m_128454_("telepastries:" + dimLocation));
            TelePastries.LOGGER.debug("Found {}'s position of {} to: {}", new Object[]{entityIn.m_5446_().m_214077_(), dimLocation, dimPos});
            return dimPos;
        }
        TelePastries.LOGGER.debug("Could not find {}'s previous location. Using current location", (Object)entityIn.m_5446_().m_214077_());
        return null;
    }

    private static CompoundTag getTag(CompoundTag tag) {
        if (tag == null || !tag.m_128441_("PlayerPersisted")) {
            return new CompoundTag();
        }
        return tag.m_128469_("PlayerPersisted");
    }

    private static Pair<Integer, Integer> customCompatBounds(ServerLevel destWorld) {
        ResourceLocation customLocation3;
        ResourceLocation customLocation2;
        ResourceLocation customLocation = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCakeDimension.get()));
        if (customLocation != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCakeMinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCakeMaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        if ((customLocation2 = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCake2Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation2);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake2MinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCake2MaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        if ((customLocation3 = ResourceLocation.m_135820_((String)((String)TeleConfig.COMMON.customCake3Dimension.get()))) != null) {
            ResourceKey customWorldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)customLocation3);
            if (destWorld.m_46472_() == customWorldKey) {
                int minY = (Integer)TeleConfig.COMMON.customCake3MinY.get();
                int maxY = (Integer)TeleConfig.COMMON.customCake3MaxY.get();
                return Pair.of((Object)minY, (Object)maxY);
            }
        }
        return Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
    }

    private static PortalInfo postProcessAndMake(ServerLevel destWorld, BlockPos pos, Entity entity) {
        ServerPlayer serverPlayer;
        if (destWorld.m_46472_() == Level.f_46428_ && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)entity;
            serverPlayer2.m_9158_(Level.f_46428_, pos, serverPlayer2.m_146908_(), true, false);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            ResourceKey twilightKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("twilightforest", "twilight_forest"));
            if (destWorld.m_46472_() == twilightKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_9158_(twilightKey, pos, serverPlayer.m_146908_(), true, false);
            }
        }
        if (ModList.get().isLoaded("lostcities")) {
            ResourceKey lostCityKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("lostcities", "lostcity"));
            if (destWorld.m_46472_() == lostCityKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_9158_(lostCityKey, pos, serverPlayer.m_146908_(), true, false);
            }
        }
        return CakeTeleporter.makePortalInfo(entity, pos);
    }

    private static PortalInfo makePortalInfo(Entity entity, BlockPos pos) {
        return new PortalInfo(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    @FunctionalInterface
    static interface LevelTeleportFinder {
        @Nullable
        public PortalInfo determineTeleportLocation(Entity var1, ServerLevel var2, Pair<Integer, Integer> var3, Long2BooleanArrayMap var4);
    }
}

