/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import org.violetmoon.zeta.module.ZetaModule;

public abstract class AbstractUndergroundBiomeHandler {
    protected List<UndergroundBiomeDesc> undergroundBiomeDescs = new ArrayList<UndergroundBiomeDesc>(2);

    public void registerUndergroundBiome(ZetaModule module, ResourceLocation id, Climate.ParameterPoint climate) {
        this.registerUndergroundBiome(new UndergroundBiomeDesc(module, id, climate));
    }

    public void registerUndergroundBiome(UndergroundBiomeDesc desc) {
        this.undergroundBiomeDescs.add(desc);
    }

    protected void addUndergroundBiomesTo(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        for (UndergroundBiomeDesc desc : this.undergroundBiomeDescs) {
            if (!desc.module().enabled) continue;
            consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)desc.climateParameterPoint(), desc.resourceKey()));
        }
    }

    public abstract void modifyVanillaOverworldPreset(OverworldBiomeBuilder var1, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> var2);

    public record UndergroundBiomeDesc(ZetaModule module, ResourceLocation id, Climate.ParameterPoint climateParameterPoint) {
        public ResourceKey<Biome> resourceKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.id);
        }
    }
}

