/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.ai.RunAwayFromPikesGoal;
import org.violetmoon.quark.content.tools.client.render.entity.SkullPikeRenderer;
import org.violetmoon.quark.content.tools.entity.SkullPike;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tools")
public class SkullPikesModule
extends ZetaModule {
    public static EntityType<SkullPike> skullPikeType;
    @Hint(key="skull_pikes")
    public static TagKey<Block> pikeTrophiesTag;
    @Config
    public static double pikeRange;

    @LoadEvent
    public final void register(ZRegister event) {
        skullPikeType = EntityType.Builder.m_20704_(SkullPike::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(3).m_20717_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new SkullPike(skullPikeType, (Level)world)).m_20712_("skull_pike");
        Quark.ZETA.registry.register(skullPikeType, "skull_pike", Registries.f_256939_);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        pikeTrophiesTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "pike_trophies"));
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        EntityRenderers.m_174036_(skullPikeType, SkullPikeRenderer::new);
    }

    @PlayEvent
    public void onPlaceBlock(ZBlock.EntityPlace event) {
        BlockPos pos;
        BlockPos down;
        Level world;
        BlockState downState;
        LevelAccessor iworld;
        BlockState state = event.getPlacedBlock();
        if (state.m_204336_(pikeTrophiesTag) && (iworld = event.getLevel()) instanceof Level && (downState = (world = (Level)iworld).m_8055_(down = (pos = event.getPos()).m_7495_())).m_204336_(BlockTags.f_13039_)) {
            SkullPike pike = new SkullPike(skullPikeType, world);
            pike.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)pike);
        }
    }

    @PlayEvent
    public void onMonsterAppear(ZEntityJoinLevel event) {
        Entity e = event.getEntity();
        if (e instanceof Monster) {
            boolean alreadySetUp;
            Monster monster = (Monster)e;
            if (!(e instanceof PatrollingMonster) && !(e instanceof Warden) && e.m_6072_() && e.m_6084_() && !(alreadySetUp = monster.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof RunAwayFromPikesGoal))) {
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)monster.f_21345_, (int)3, (Goal)new RunAwayFromPikesGoal((PathfinderMob)monster, (float)pikeRange, 1.0, 1.2));
            }
        }
    }

    static {
        pikeRange = 5.0;
    }
}

