/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.violetmoon.quark.content.tools.base.RuneColor;

public class GlintRenderTypes
extends RenderType {
    public static Map<RuneColor, RenderType> glint = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildGlintRenderType);
    public static Map<RuneColor, RenderType> glintTranslucent = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildGlintTranslucentRenderType);
    public static Map<RuneColor, RenderType> entityGlint = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildEntityGlintRenderType);
    public static Map<RuneColor, RenderType> glintDirect = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildGlintDirectRenderType);
    public static Map<RuneColor, RenderType> entityGlintDirect = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildEntityGlintDriectRenderType);
    public static Map<RuneColor, RenderType> armorGlint = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildArmorGlintRenderType);
    public static Map<RuneColor, RenderType> armorEntityGlint = GlintRenderTypes.newRenderMap(GlintRenderTypes::buildArmorEntityGlintRenderType);

    private GlintRenderTypes(String name, VertexFormat vf, VertexFormat.Mode mode, int bufSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clean) {
        super(name, vf, mode, bufSize, affectsCrumbling, sortOnUpload, setup, clean);
        throw new UnsupportedOperationException("Don't instantiate this");
    }

    public static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map) {
        GlintRenderTypes.addGlintTypes(map, glint);
        GlintRenderTypes.addGlintTypes(map, glintTranslucent);
        GlintRenderTypes.addGlintTypes(map, entityGlint);
        GlintRenderTypes.addGlintTypes(map, glintDirect);
        GlintRenderTypes.addGlintTypes(map, entityGlintDirect);
        GlintRenderTypes.addGlintTypes(map, armorGlint);
        GlintRenderTypes.addGlintTypes(map, armorEntityGlint);
    }

    private static Map<RuneColor, RenderType> newRenderMap(Function<String, RenderType> func) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (RuneColor color : RuneColor.values()) {
            map.put(color, func.apply(color.m_7912_()));
        }
        return map;
    }

    private static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map, Map<RuneColor, RenderType> typeMap) {
        for (RenderType renderType : typeMap.values()) {
            if (map.containsKey((Object)renderType)) continue;
            map.put((Object)renderType, (Object)new BufferBuilder(renderType.m_110507_()));
        }
    }

    private static RenderType buildGlintRenderType(String name) {
        return RenderType.m_173215_((String)("glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173081_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildGlintTranslucentRenderType(String name) {
        return RenderType.m_173215_((String)("glint_translucent_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildEntityGlintRenderType(String name) {
        return RenderType.m_173215_((String)("entity_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110151_).m_110691_(false));
    }

    private static RenderType buildGlintDirectRenderType(String name) {
        return RenderType.m_173215_((String)("glint_direct_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173082_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildEntityGlintDriectRenderType(String name) {
        return RenderType.m_173215_((String)("entity_glint_direct_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173084_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110691_(false));
    }

    private static RenderType buildArmorGlintRenderType(String name) {
        return RenderType.m_173215_((String)("armor_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173078_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110669_(RenderStateShard.f_110119_).m_110691_(false));
    }

    private static RenderType buildArmorEntityGlintRenderType(String name) {
        return RenderType.m_173215_((String)("armor_entity_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173079_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110669_(RenderStateShard.f_110119_).m_110691_(false));
    }

    private static ResourceLocation texture(String name) {
        return new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
    }
}

