/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedexcrafting.block.CombinationCrafterBlock;
import thelm.packagedexcrafting.block.entity.MarkedPedestalBlockEntity;
import thelm.packagedexcrafting.integration.appeng.blockentity.AECombinationCrafterBlockEntity;
import thelm.packagedexcrafting.inventory.CombinationCrafterItemHandler;
import thelm.packagedexcrafting.menu.CombinationCrafterMenu;
import thelm.packagedexcrafting.recipe.ICombinationPackageRecipeInfo;

public class CombinationCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static final BlockEntityType<CombinationCrafterBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AECombinationCrafterBlockEntity::new, () -> () -> CombinationCrafterBlockEntity::new).get()), (Block[])new Block[]{CombinationCrafterBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000000;
    public static boolean drawMEEnergy = false;
    public int requiredPedestals = 0;
    public boolean isWorking = false;
    public long energyReq = 0L;
    public long remainingProgress = 0L;
    public int energyUsage = 0;
    public ICombinationPackageRecipeInfo currentRecipe;
    public List<BlockPos> pedestals = new ArrayList<BlockPos>();

    public CombinationCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new CombinationCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedexcrafting.combination_crafter");
    }

    public Component getMessage() {
        if (this.isWorking) {
            return null;
        }
        int usablePedestals = this.getEmptyPedestals().size();
        MutableComponent message = Component.m_237110_((String)"block.packagedexcrafting.combination_crafter.pedestals.usable", (Object[])new Object[]{usablePedestals});
        if (this.requiredPedestals > 0) {
            message.m_130946_("\n");
            message.m_7220_((Component)Component.m_237110_((String)"block.packagedexcrafting.combination_crafter.pedestals.required", (Object[])new Object[]{this.requiredPedestals}));
        }
        return message;
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0L) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof ICombinationPackageRecipeInfo) {
            ICombinationPackageRecipeInfo recipe = (ICombinationPackageRecipeInfo)recipeInfo;
            List<ItemStack> pedestalInputs = recipe.getPedestalInputs();
            List<BlockPos> emptyPedestals = this.getEmptyPedestals();
            this.requiredPedestals = Math.max(this.requiredPedestals, pedestalInputs.size());
            if (emptyPedestals.size() >= pedestalInputs.size()) {
                this.pedestals.clear();
                this.pedestals.addAll(emptyPedestals.subList(0, pedestalInputs.size()));
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.energyReq = this.remainingProgress = recipe.getEnergyRequired();
                this.energyUsage = recipe.getEnergyUsage();
                this.itemHandler.setStackInSlot(0, recipe.getCoreInput());
                for (int i = 0; i < this.pedestals.size(); ++i) {
                    ((MarkedPedestalBlockEntity)this.f_58857_.m_7702_(this.pedestals.get(i))).getItemHandler().setStackInSlot(0, pedestalInputs.get(i).m_41777_());
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::m_41619_);
    }

    protected void tickProcess() {
        if (this.pedestals.stream().map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).anyMatch(be -> !(be instanceof MarkedPedestalBlockEntity) || be.m_58901_())) {
            this.endProcess();
        } else {
            int energy = this.energyStorage.extractEnergy((int)Math.min((long)this.energyUsage, this.remainingProgress), false);
            this.remainingProgress -= (long)energy;
            if (!this.f_58857_.f_46443_) {
                this.spawnParticles(ParticleTypes.f_123811_, this.f_58858_, 1.15, 2);
                if (this.shouldSpawnItemParticles()) {
                    for (BlockPos pedestalPos : this.pedestals) {
                        ItemStack stack = ((MarkedPedestalBlockEntity)this.f_58857_.m_7702_(pedestalPos)).getItemHandler().getStackInSlot(0);
                        this.spawnItemParticles(pedestalPos, stack);
                    }
                }
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.pedestals.stream().map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).anyMatch(be -> !(be instanceof MarkedPedestalBlockEntity) || be.m_58901_())) {
            this.endProcess();
            return;
        }
        for (BlockPos pedestalPos : this.pedestals) {
            BaseItemHandler pedestalInv = ((MarkedPedestalBlockEntity)this.f_58857_.m_7702_(pedestalPos)).getItemHandler();
            pedestalInv.setStackInSlot(0, MiscHelper.INSTANCE.getContainerItem(pedestalInv.getStackInSlot(0)));
            this.spawnParticles(ParticleTypes.f_123762_, pedestalPos, 1.1, 20);
        }
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.spawnParticles(ParticleTypes.f_123810_, this.f_58858_, 1.1, 50);
        this.itemHandler.setStackInSlot(1, this.currentRecipe.getOutput());
        this.endProcess();
    }

    public void endProcess() {
        this.energyReq = 0L;
        this.remainingProgress = 0L;
        this.energyUsage = 0;
        this.pedestals.stream().map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(be -> be instanceof MarkedPedestalBlockEntity && !be.m_58901_()).forEach(be -> ((MarkedPedestalBlockEntity)((Object)be)).ejectItem());
        this.pedestals.clear();
        this.isWorking = false;
        this.currentRecipe = null;
        this.m_6596_();
    }

    protected List<BlockPos> getEmptyPedestals() {
        return BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-3, 0, -3), (BlockPos)this.f_58858_.m_7918_(3, 0, 3)).map(pos -> {
            MarkedPedestalBlockEntity pedestal;
            BlockEntity patt7378$temp = this.f_58857_.m_7702_(pos);
            if (patt7378$temp instanceof MarkedPedestalBlockEntity && (pedestal = (MarkedPedestalBlockEntity)patt7378$temp).getItemHandler().getStackInSlot(0).m_41619_()) {
                return pos.m_7949_();
            }
            return null;
        }).filter((Predicate<BlockPos>)Predicates.notNull()).toList();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 1 : 0;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity == null || blockEntity instanceof UnpackagerBlockEntity || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve().get();
            for (int i = 1; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.f_41583_);
            }
        }
    }

    protected <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    protected void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        double x = (double)pedestalPos.m_123341_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double y = (double)pedestalPos.m_123342_() + level.m_213780_().m_188500_() * 0.2 + 1.4;
        double z = (double)pedestalPos.m_123343_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double velX = this.f_58858_.m_123341_() - pedestalPos.m_123341_();
        double velY = 0.25;
        double velZ = this.f_58858_.m_123343_() - pedestalPos.m_123343_();
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    protected boolean shouldSpawnItemParticles() {
        return this.remainingProgress < (long)(this.energyUsage * 40);
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::m_41619_)) {
            return 15;
        }
        return 0;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isWorking = nbt.m_128471_("Working");
        this.remainingProgress = nbt.m_128454_("Progress");
        this.energyReq = nbt.m_128454_("EnergyReq");
        this.energyUsage = nbt.m_128451_("EnergyUsage");
        this.currentRecipe = null;
        if (nbt.m_128441_("Recipe")) {
            CompoundTag tag = nbt.m_128469_("Recipe");
            IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
            if (recipe instanceof ICombinationPackageRecipeInfo) {
                ICombinationPackageRecipeInfo combinationRecipe;
                this.currentRecipe = combinationRecipe = (ICombinationPackageRecipeInfo)recipe;
            }
            this.pedestals.clear();
            ListTag pedestalsTag = nbt.m_128437_("Pedestals", 11);
            for (int i = 0; i < pedestalsTag.size(); ++i) {
                int[] posArray = pedestalsTag.m_128767_(i);
                BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.pedestals.add(pos);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void m_183515_(CompoundTag nbt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadSync(CompoundTag nbt) {
        super.loadSync(nbt);
        this.itemHandler.load(nbt);
    }

    public CompoundTag saveSync(CompoundTag nbt) {
        super.saveSync(nbt);
        this.itemHandler.save(nbt);
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0L || this.energyReq <= 0L) {
            return 0;
        }
        return (int)((long)scale * (this.energyReq - this.remainingProgress) / this.energyReq);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new CombinationCrafterMenu(windowId, inventory, this);
    }

    private static /* synthetic */ void lambda$saveAdditional$11(ListTag pedestalsTag, int[] arr) {
        pedestalsTag.add((Object)new IntArrayTag(arr));
    }
}

