/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.UnpackagerItemHandlerWrapper;

public class UnpackagerItemHandler
extends BaseItemHandler<UnpackagerBlockEntity> {
    public UnpackagerItemHandler(UnpackagerBlockEntity blockEntity) {
        super(blockEntity, 11);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot == 9) {
            this.updateRecipeList();
        } else if (slot != 10) {
            this.clearRejectedIndexes();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 9) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 9 -> stack.m_41720_() instanceof IPackageRecipeListItem;
            case 10 -> stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            default -> stack.m_41720_() instanceof IPackageItem;
        };
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.updateRecipeList();
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new UnpackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int m_6413_(int id) {
        if (id < 10) {
            return ((UnpackagerBlockEntity)this.blockEntity).trackers[id].getSyncValue();
        }
        return switch (id) {
            case 10 -> {
                if (((UnpackagerBlockEntity)this.blockEntity).blocking) {
                    yield 1;
                }
                yield 0;
            }
            case 11 -> ((UnpackagerBlockEntity)this.blockEntity).trackerCount;
            case 12 -> ((UnpackagerBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void m_8050_(int id, int value) {
        if (id < 10) {
            ((UnpackagerBlockEntity)this.blockEntity).trackers[id].setSyncValue(value);
        }
        switch (id) {
            case 10: {
                ((UnpackagerBlockEntity)this.blockEntity).blocking = value != 0;
                break;
            }
            case 11: {
                ((UnpackagerBlockEntity)this.blockEntity).trackerCount = value;
                break;
            }
            case 12: {
                ((UnpackagerBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int m_6499_() {
        return 13;
    }

    public void updateRecipeList() {
        ((UnpackagerBlockEntity)this.blockEntity).recipeList.clear();
        ItemStack listStack = this.getStackInSlot(9);
        Item item = listStack.m_41720_();
        if (item instanceof IPackageRecipeListItem) {
            IPackageRecipeListItem listItem = (IPackageRecipeListItem)item;
            ((UnpackagerBlockEntity)this.blockEntity).recipeList.addAll(listItem.getRecipeList(((UnpackagerBlockEntity)this.blockEntity).m_58904_(), listStack).getRecipeList());
        }
        if (((UnpackagerBlockEntity)this.blockEntity).m_58904_() != null && !((UnpackagerBlockEntity)this.blockEntity).m_58904_().f_46443_) {
            ((UnpackagerBlockEntity)this.blockEntity).postPatternChange();
        }
    }

    public void clearRejectedIndexes() {
        for (UnpackagerBlockEntity.PackageTracker tracker : ((UnpackagerBlockEntity)this.blockEntity).trackers) {
            tracker.clearRejectedIndexes();
        }
    }
}

