/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.PackagerItemHandlerWrapper;
import thelm.packagedauto.util.MiscHelper;

public class PackagerItemHandler
extends BaseItemHandler<PackagerBlockEntity> {
    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        super(blockEntity, 12);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot < 9 && !((PackagerBlockEntity)this.blockEntity).m_58904_().f_46443_ && ((PackagerBlockEntity)this.blockEntity).isWorking && !this.getStackInSlot(slot).m_41619_() && !((PackagerBlockEntity)this.blockEntity).isInputValid()) {
            ((PackagerBlockEntity)this.blockEntity).endProcess();
        }
        if (slot == 10) {
            this.updatePatternList();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 10) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 9 -> false;
            case 10 -> {
                if (stack.m_41720_() instanceof IPackageRecipeListItem || stack.m_41720_() instanceof IPackageItem) {
                    yield true;
                }
                yield false;
            }
            case 11 -> stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            default -> {
                if (((PackagerBlockEntity)this.blockEntity).isWorking) {
                    if (!this.getStackInSlot(slot).m_41619_()) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
        };
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new PackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int m_6413_(int id) {
        return switch (id) {
            case 0 -> ((PackagerBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((PackagerBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((PackagerBlockEntity)this.blockEntity).mode.ordinal();
            case 3 -> ((PackagerBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void m_8050_(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagerBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((PackagerBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((PackagerBlockEntity)this.blockEntity).mode = PackagerBlockEntity.Mode.values()[value];
                break;
            }
            case 3: {
                ((PackagerBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int m_6499_() {
        return 4;
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.updatePatternList();
    }

    public void updatePatternList() {
        ((PackagerBlockEntity)this.blockEntity).patternList.clear();
        ItemStack listStack = this.getStackInSlot(10);
        Item item = listStack.m_41720_();
        if (item instanceof IPackageRecipeListItem) {
            IPackageRecipeListItem listItem = (IPackageRecipeListItem)item;
            listItem.getRecipeList(((PackagerBlockEntity)this.blockEntity).m_58904_(), listStack).getRecipeList().stream().filter(IPackageRecipeInfo::isValid).forEach(recipe -> {
                recipe.getPatterns().forEach(((PackagerBlockEntity)this.blockEntity).patternList::add);
                recipe.getExtraPatterns().forEach(((PackagerBlockEntity)this.blockEntity).patternList::add);
            });
        } else {
            item = listStack.m_41720_();
            if (item instanceof IPackageItem) {
                IPackageItem packageItem = (IPackageItem)item;
                IPackageRecipeInfo recipe2 = packageItem.getRecipeInfo(listStack);
                int index = packageItem.getIndex(listStack);
                if (recipe2 != null && recipe2.isValid() && recipe2.validPatternIndex(index)) {
                    ((PackagerBlockEntity)this.blockEntity).patternList.add(recipe2.getPatterns().get(index));
                }
            }
        }
        switch (((PackagerBlockEntity)this.blockEntity).mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXACT: {
                boolean bl = false;
                break;
            }
            case DISJOINT: {
                boolean bl = MiscHelper.INSTANCE.arePatternsDisjoint(((PackagerBlockEntity)this.blockEntity).patternList);
                break;
            }
            case FIRST: {
                boolean bl = ((PackagerBlockEntity)this.blockEntity).disjoint = true;
            }
        }
        if (((PackagerBlockEntity)this.blockEntity).m_58904_() != null && !((PackagerBlockEntity)this.blockEntity).m_58904_().f_46443_) {
            ((PackagerBlockEntity)this.blockEntity).postPatternChange();
        }
        if (((PackagerBlockEntity)this.blockEntity).m_58904_() != null) {
            BlockPos.m_121990_((BlockPos)((PackagerBlockEntity)this.blockEntity).m_58899_().m_7918_(-1, -1, -1), (BlockPos)((PackagerBlockEntity)this.blockEntity).m_58899_().m_7918_(1, 1, 1)).map(arg_0 -> ((Level)((PackagerBlockEntity)this.blockEntity).m_58904_()).m_7702_(arg_0)).filter(t -> t instanceof PackagerExtensionBlockEntity).map(t -> (PackagerExtensionBlockEntity)((Object)t)).forEach(t -> t.updatePatternList());
        }
    }
}

